/*
 * Decompiled with CFR 0.152.
 */
package io.jmix.gradle;

import io.jmix.gradle.PersistenceProviderEnhancing;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;

public class EclipselinkEnhancing
implements PersistenceProviderEnhancing {
    @Override
    public void run(Project project, SourceSet sourceSet, Set<String> allStores) {
        for (String storeName : allStores) {
            Configuration conf = (Configuration)project.getConfigurations().findByName(sourceSet.getCompileClasspathConfigurationName());
            if (!this.findJpaDependencies(conf.getResolvedConfiguration().getFirstLevelModuleDependencies(), new HashSet())) {
                project.getLogger().info("Jpa dependencies not found in classpath, EclipseLink enhancer will not run");
                return;
            }
            project.getLogger().lifecycle("Running EclipseLink enhancer in {} for {}", new Object[]{project, sourceSet});
            project.javaexec(javaExecSpec -> {
                javaExecSpec.setMain("org.eclipse.persistence.tools.weaving.jpa.StaticWeave");
                javaExecSpec.setClasspath((FileCollection)project.files(new Object[]{project.getConfigurations().getByName("enhancing").getAsFileTree(), sourceSet.getCompileClasspath().getFiles(), sourceSet.getJava().getOutputDir().listFiles()}));
                javaExecSpec.args(new Object[]{"-loglevel", "INFO", "-persistenceinfo", project.getBuildDir() + "/tmp/entitiesEnhancing/" + sourceSet.getName() + "/" + ("main".equals(storeName) ? "" : storeName + '-') + "persistence", sourceSet.getJava().getOutputDir().getAbsolutePath(), sourceSet.getJava().getOutputDir().getAbsolutePath()});
                javaExecSpec.setDebug(project.hasProperty("debugEnhancing") && Boolean.parseBoolean((String)project.property("debugEnhancing")));
            });
        }
    }

    protected boolean findJpaDependencies(Set<ResolvedDependency> deps, Set visited) {
        for (ResolvedDependency dep : deps) {
            if (visited.contains(dep)) continue;
            if ("org.eclipse.persistence".equals(dep.getModuleGroup()) && "org.eclipse.persistence.core".equals(dep.getModuleName())) {
                return true;
            }
            visited.add(dep);
            if (!this.findJpaDependencies(dep.getChildren(), visited)) continue;
            return true;
        }
        return false;
    }
}

