/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.revapi;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;
import org.revapi.AnalysisContext;
import org.revapi.Archive;
import org.revapi.java.spi.JarExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HpiJarExtractor
implements JarExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(HpiJarExtractor.class);
    private static final String LIB_FOLDER = "WEB-INF/lib/";
    private static final Pattern HPI_PATTERN = Pattern.compile("(?<groupId>.*):(?<artifactId>.*):hpi:(?<version>.*)");

    public Optional<InputStream> extract(Archive archive) {
        Matcher matcher = HPI_PATTERN.matcher(archive.getName());
        if (matcher.matches()) {
            LOG.debug("Analyzing " + archive.getName());
            return this.extractJarFile(archive, matcher.group("artifactId"));
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<InputStream> extractJarFile(Archive archive, String artifactId) {
        try (ZipInputStream hpiPluginArchive = new ZipInputStream(archive.openStream());){
            ZipEntry hpiEntry = hpiPluginArchive.getNextEntry();
            int prefixLen = LIB_FOLDER.length();
            while (hpiEntry != null) {
                if (StringUtils.startsWith((CharSequence)hpiEntry.getName(), (CharSequence)(LIB_FOLDER + artifactId))) {
                    Optional<InputStream> optional = this.extractPluginJar(hpiPluginArchive, hpiEntry.getName());
                    return optional;
                }
                hpiEntry = hpiPluginArchive.getNextEntry();
            }
            return Optional.empty();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Optional.empty();
    }

    private Optional<InputStream> extractPluginJar(ZipInputStream hpiPluginArchive, String name) {
        try {
            LOG.debug("--- Extracting classes of " + name + " to temporary archive.");
            byte[] buffer = new byte[2048];
            final Path path = Files.createTempFile("revapi-java-jarextract-hpi", null, new FileAttribute[0]);
            try (FileOutputStream fos = new FileOutputStream(path.toFile());
                 BufferedOutputStream bos = new BufferedOutputStream(fos, buffer.length);){
                int len;
                while ((len = hpiPluginArchive.read(buffer)) > 0) {
                    bos.write(buffer, 0, len);
                }
            }
            return Optional.of(new FileInputStream(path.toFile()){

                @Override
                public void close() throws IOException {
                    super.close();
                    Files.delete(path);
                }
            });
        }
        catch (IOException exception) {
            LOG.error("Can't extract " + name, (Throwable)exception);
            return Optional.empty();
        }
    }

    public String getExtensionId() {
        return "hpi";
    }

    public Reader getJSONSchema() {
        return new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/hpiJarExtract-config-schema.json"), Charset.forName("UTF-8"));
    }

    public void initialize(AnalysisContext analysisContext) {
    }
}

