/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.test.fips;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import java.util.stream.Stream;

public interface FIPSTestBundleProvider {
    public static final Logger LOGGER = Logger.getLogger(FIPSTestBundleProvider.class.getName());
    public static final String DEFAULT_VERSION = "fips-140_2-1.x";
    public static final String SYS_PROP_KEY = "fips.test.bundle.version";
    public static final String ENV_VAR_KEY = "FIPS_TEST_BUNDLE_VERSION";

    public String getVersion();

    public List<String> getJavaOptions() throws IOException;

    public List<File> getBootClasspathFiles() throws IOException;

    public static FIPSTestBundleProvider get() {
        return FIPSTestBundleProvider.get(DEFAULT_VERSION);
    }

    public static FIPSTestBundleProvider get(String version) {
        String overrideVersion = System.getenv(ENV_VAR_KEY);
        Stream<ServiceLoader.Provider<FIPSTestBundleProvider>> stream = ServiceLoader.load(FIPSTestBundleProvider.class).stream();
        if (overrideVersion != null) {
            LOGGER.fine(() -> "use env var to init fips bundle provider: " + overrideVersion);
            return (FIPSTestBundleProvider)stream.filter(provider -> overrideVersion.equals(((FIPSTestBundleProvider)provider.get()).getVersion())).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find FIPS Bundle provider from env var 'FIPS_TEST_BUNDLE_VERSION' with value " + overrideVersion)).get();
        }
        String sysPropVersion = System.getProperty(SYS_PROP_KEY);
        if (sysPropVersion != null) {
            LOGGER.fine(() -> "use sys prop to init fips bundle provider: " + sysPropVersion);
            return (FIPSTestBundleProvider)stream.filter(provider -> sysPropVersion.equals(((FIPSTestBundleProvider)provider.get()).getVersion())).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find FIPS Bundle provider from env var 'fips.test.bundle.version' with value " + sysPropVersion)).get();
        }
        if (version == null || version.isEmpty()) {
            throw new IllegalArgumentException("Cannot find FIPS Bundle provider with version null or empty");
        }
        return (FIPSTestBundleProvider)stream.filter(provider -> version.equals(((FIPSTestBundleProvider)provider.get()).getVersion())).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find FIPS Bundle provider from version " + version)).get();
    }
}

