/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.test.fips;

import io.jenkins.test.fips.FIPSTestBundleProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class FIPS1402BC1x
implements FIPSTestBundleProvider {
    public static final String VERSION = "fips-140_2-1.x";

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public List<String> getJavaOptions() throws IOException {
        return List.of("-Dsecurity.useSystemPropertiesFile=false", "-Djava.security.properties==" + this.writeFIPSJavaSecurityFile().toUri(), "-Dorg.bouncycastle.fips.approved_only=true", "-Djavax.net.ssl.trustStoreType=PKCS12", "-Djenkins.security.FIPS140.COMPLIANCE=true");
    }

    @Override
    public List<File> getBootClasspathFiles() throws IOException {
        return List.of(this.extractJar("bc-fips.jar").toFile(), this.extractJar("bcpkix-fips.jar").toFile(), this.extractJar("bctls-fips.jar").toFile());
    }

    private Path extractJar(String jarName) throws IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("fips-140_2-1.x/" + jarName);
        Path bcFips = Files.createTempFile(jarName, "jar", new FileAttribute[0]);
        bcFips.toFile().deleteOnExit();
        try (OutputStream os = Files.newOutputStream(bcFips, new OpenOption[0]);){
            IOUtils.copy((InputStream)url.openStream(), (OutputStream)os);
        }
        return bcFips;
    }

    private Path writeFIPSJavaSecurityFile() throws IOException {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            throw new IllegalArgumentException("Cannot find java.home property");
        }
        Path javaSecurity = Paths.get(javaHome, "conf", "security", "java.security");
        Properties properties = new Properties();
        Path securityFile = Files.createTempFile("java", ".security", new FileAttribute[0]);
        securityFile.toFile().deleteOnExit();
        try (InputStream inputStream = Files.newInputStream(javaSecurity, new OpenOption[0]);
             OutputStream outputStream = Files.newOutputStream(securityFile, new OpenOption[0]);){
            properties.load(inputStream);
            properties.keySet().removeIf(o -> ((String)o).startsWith("security.provider"));
            properties.put("security.provider.1", "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider C:HYBRID;ENABLE{All};");
            properties.put("security.provider.2", "org.bouncycastle.jsse.provider.BouncyCastleJsseProvider fips:BCFIPS");
            properties.put("security.provider.3", "sun.security.provider.Sun");
            properties.put("fips.provider.1", "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider C:HYBRID;ENABLE{All};");
            properties.put("fips.provider.2", "org.bouncycastle.jsse.provider.BouncyCastleJsseProvider fips:BCFIPS");
            properties.put("keystore.type", "BCFKS");
            properties.put("ssl.KeyManagerFactory.algorithm", "PKIX");
            properties.put("fips.keystore.type", "BCFKS");
            properties.store(outputStream, "");
        }
        return securityFile;
    }
}

