/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.servlet;

import io.jenkins.servlet.FilterRegistrationDynamicWrapper;
import io.jenkins.servlet.FilterRegistrationWrapper;
import io.jenkins.servlet.FilterWrapper;
import io.jenkins.servlet.RequestDispatcherWrapper;
import io.jenkins.servlet.ServletExceptionWrapper;
import io.jenkins.servlet.ServletRegistrationDynamicWrapper;
import io.jenkins.servlet.ServletRegistrationWrapper;
import io.jenkins.servlet.ServletWrapper;
import io.jenkins.servlet.SessionCookieConfigWrapper;
import io.jenkins.servlet.SessionTrackingModeWrapper;
import io.jenkins.servlet.descriptor.JspConfigDescriptorWrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;

public class ServletContextWrapper {
    public static ServletContext toJakartaServletContext(final javax.servlet.ServletContext from) {
        Objects.requireNonNull(from);
        return new ServletContext(){

            public String getContextPath() {
                return from.getContextPath();
            }

            public ServletContext getContext(String uripath) {
                return ServletContextWrapper.toJakartaServletContext(from.getContext(uripath));
            }

            public int getMajorVersion() {
                return from.getMajorVersion();
            }

            public int getMinorVersion() {
                return from.getMinorVersion();
            }

            public int getEffectiveMajorVersion() {
                return from.getEffectiveMajorVersion();
            }

            public int getEffectiveMinorVersion() {
                return from.getEffectiveMinorVersion();
            }

            public String getMimeType(String file) {
                return from.getMimeType(file);
            }

            public Set<String> getResourcePaths(String paths) {
                return from.getResourcePaths(paths);
            }

            public URL getResource(String path) throws MalformedURLException {
                return from.getResource(path);
            }

            public InputStream getResourceAsStream(String path) {
                return from.getResourceAsStream(path);
            }

            public RequestDispatcher getRequestDispatcher(String path) {
                return RequestDispatcherWrapper.toJakartaRequestDispatcher(from.getRequestDispatcher(path));
            }

            public RequestDispatcher getNamedDispatcher(String path) {
                return RequestDispatcherWrapper.toJakartaRequestDispatcher(from.getNamedDispatcher(path));
            }

            public Servlet getServlet(String name) throws jakarta.servlet.ServletException {
                try {
                    return ServletWrapper.toJakartaServlet(from.getServlet(name));
                }
                catch (ServletException e) {
                    throw ServletExceptionWrapper.toJakartaServletException(e);
                }
            }

            public Enumeration<Servlet> getServlets() {
                return Collections.enumeration(Collections.list(from.getServlets()).stream().map(ServletWrapper::toJakartaServlet).collect(Collectors.toList()));
            }

            public Enumeration<String> getServletNames() {
                return from.getServletNames();
            }

            public void log(String msg) {
                from.log(msg);
            }

            public void log(Exception exception, String msg) {
                from.log(exception, msg);
            }

            public void log(String message, Throwable throwable) {
                from.log(message, throwable);
            }

            public String getRealPath(String path) {
                return from.getRealPath(path);
            }

            public String getServerInfo() {
                return from.getServerInfo();
            }

            public String getInitParameter(String name) {
                return from.getInitParameter(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return from.getInitParameterNames();
            }

            public boolean setInitParameter(String name, String value) {
                return from.setInitParameter(name, value);
            }

            public Object getAttribute(String name) {
                return from.getAttribute(name);
            }

            public Enumeration<String> getAttributeNames() {
                return from.getAttributeNames();
            }

            public void setAttribute(String name, Object object) {
                from.setAttribute(name, object);
            }

            public void removeAttribute(String name) {
                from.removeAttribute(name);
            }

            public String getServletContextName() {
                return from.getServletContextName();
            }

            public ServletRegistration.Dynamic addServlet(String servletName, String className) {
                return ServletRegistrationDynamicWrapper.toJakartaServletRegistrationDynamic(from.addServlet(servletName, className));
            }

            public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
                return ServletRegistrationDynamicWrapper.toJakartaServletRegistrationDynamic(from.addServlet(servletName, ServletWrapper.fromJakartaServlet(servlet)));
            }

            public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
                throw new UnsupportedOperationException();
            }

            public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
                return ServletRegistrationDynamicWrapper.toJakartaServletRegistrationDynamic(from.addJspFile(servletName, jspFile));
            }

            public <T extends Servlet> T createServlet(Class<T> clazz) {
                throw new UnsupportedOperationException();
            }

            public ServletRegistration getServletRegistration(String servletName) {
                return ServletRegistrationWrapper.toJakartaServletRegistration(from.getServletRegistration(servletName));
            }

            public Map<String, ? extends ServletRegistration> getServletRegistrations() {
                return from.getServletRegistrations().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ServletRegistrationWrapper.toJakartaServletRegistration((javax.servlet.ServletRegistration)entry.getValue())));
            }

            public FilterRegistration.Dynamic addFilter(String filterName, String className) {
                return FilterRegistrationDynamicWrapper.toJakartaFilterRegistrationDynamic(from.addFilter(filterName, className));
            }

            public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
                return FilterRegistrationDynamicWrapper.toJakartaFilterRegistrationDynamic(from.addFilter(filterName, FilterWrapper.fromJakartaFilter(filter)));
            }

            public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
                throw new UnsupportedOperationException();
            }

            public <T extends Filter> T createFilter(Class<T> clazz) {
                throw new UnsupportedOperationException();
            }

            public jakarta.servlet.FilterRegistration getFilterRegistration(String filterName) {
                return FilterRegistrationWrapper.toJakartaFilterRegistration(from.getFilterRegistration(filterName));
            }

            public Map<String, ? extends jakarta.servlet.FilterRegistration> getFilterRegistrations() {
                return from.getFilterRegistrations().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> FilterRegistrationWrapper.toJakartaFilterRegistration((FilterRegistration)entry.getValue())));
            }

            public SessionCookieConfig getSessionCookieConfig() {
                return SessionCookieConfigWrapper.toJakartaSessionCookieConfig(from.getSessionCookieConfig());
            }

            public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
                from.setSessionTrackingModes(sessionTrackingModes.stream().map(SessionTrackingModeWrapper::fromJakartaSessionTrackingMode).collect(Collectors.toSet()));
            }

            public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
                return from.getDefaultSessionTrackingModes().stream().map(SessionTrackingModeWrapper::toJakartaSessionTrackingMode).collect(Collectors.toSet());
            }

            public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
                return from.getEffectiveSessionTrackingModes().stream().map(SessionTrackingModeWrapper::toJakartaSessionTrackingMode).collect(Collectors.toSet());
            }

            public void addListener(String className) {
                from.addListener(className);
            }

            public <T extends EventListener> void addListener(T t) {
                from.addListener(t);
            }

            public void addListener(Class<? extends EventListener> listenerClass) {
                from.addListener(listenerClass);
            }

            public <T extends EventListener> T createListener(Class<T> clazz) throws jakarta.servlet.ServletException {
                try {
                    return from.createListener(clazz);
                }
                catch (ServletException e) {
                    throw ServletExceptionWrapper.toJakartaServletException(e);
                }
            }

            public JspConfigDescriptor getJspConfigDescriptor() {
                return JspConfigDescriptorWrapper.toJakartaJspConfigDescriptor(from.getJspConfigDescriptor());
            }

            public ClassLoader getClassLoader() {
                return from.getClassLoader();
            }

            public void declareRoles(String ... roleNames) {
                from.declareRoles(roleNames);
            }

            public String getVirtualServerName() {
                return from.getVirtualServerName();
            }

            public int getSessionTimeout() {
                return from.getSessionTimeout();
            }

            public void setSessionTimeout(int sessionTimeout) {
                from.setSessionTimeout(sessionTimeout);
            }

            public String getRequestCharacterEncoding() {
                return from.getRequestCharacterEncoding();
            }

            public void setRequestCharacterEncoding(String encoding) {
                from.setRequestCharacterEncoding(encoding);
            }

            public String getResponseCharacterEncoding() {
                return from.getResponseCharacterEncoding();
            }

            public void setResponseCharacterEncoding(String encoding) {
                from.setResponseCharacterEncoding(encoding);
            }
        };
    }

    public static javax.servlet.ServletContext fromJakartServletContext(final ServletContext from) {
        Objects.requireNonNull(from);
        return new javax.servlet.ServletContext(){

            @Override
            public String getContextPath() {
                return from.getContextPath();
            }

            @Override
            public javax.servlet.ServletContext getContext(String uripath) {
                return ServletContextWrapper.fromJakartServletContext(from.getContext(uripath));
            }

            @Override
            public int getMajorVersion() {
                return from.getMajorVersion();
            }

            @Override
            public int getMinorVersion() {
                return from.getMinorVersion();
            }

            @Override
            public int getEffectiveMajorVersion() {
                return from.getEffectiveMajorVersion();
            }

            @Override
            public int getEffectiveMinorVersion() {
                return from.getEffectiveMinorVersion();
            }

            @Override
            public String getMimeType(String file) {
                return from.getMimeType(file);
            }

            @Override
            public Set<String> getResourcePaths(String path) {
                return from.getResourcePaths(path);
            }

            @Override
            public URL getResource(String path) throws MalformedURLException {
                return from.getResource(path);
            }

            @Override
            public InputStream getResourceAsStream(String path) {
                return from.getResourceAsStream(path);
            }

            @Override
            public javax.servlet.RequestDispatcher getRequestDispatcher(String path) {
                return RequestDispatcherWrapper.fromJakartaRequestDispatcher(from.getRequestDispatcher(path));
            }

            @Override
            public javax.servlet.RequestDispatcher getNamedDispatcher(String name) {
                return RequestDispatcherWrapper.fromJakartaRequestDispatcher(from.getNamedDispatcher(name));
            }

            @Override
            public javax.servlet.Servlet getServlet(String name) throws ServletException {
                try {
                    return ServletWrapper.fromJakartaServlet(from.getServlet(name));
                }
                catch (jakarta.servlet.ServletException e) {
                    throw ServletExceptionWrapper.fromJakartaServletException(e);
                }
            }

            @Override
            public Enumeration<javax.servlet.Servlet> getServlets() {
                return Collections.enumeration(Collections.list(from.getServlets()).stream().map(ServletWrapper::fromJakartaServlet).collect(Collectors.toList()));
            }

            @Override
            public Enumeration<String> getServletNames() {
                return from.getServletNames();
            }

            @Override
            public void log(String msg) {
                from.log(msg);
            }

            @Override
            public void log(Exception exception, String msg) {
                from.log(exception, msg);
            }

            @Override
            public void log(String message, Throwable throwable) {
                from.log(message, throwable);
            }

            @Override
            public String getRealPath(String path) {
                return from.getRealPath(path);
            }

            @Override
            public String getServerInfo() {
                return from.getServerInfo();
            }

            @Override
            public String getInitParameter(String name) {
                return from.getInitParameter(name);
            }

            @Override
            public Enumeration<String> getInitParameterNames() {
                return from.getInitParameterNames();
            }

            @Override
            public boolean setInitParameter(String name, String value) {
                return from.setInitParameter(name, value);
            }

            @Override
            public Object getAttribute(String name) {
                return from.getAttribute(name);
            }

            @Override
            public Enumeration<String> getAttributeNames() {
                return from.getAttributeNames();
            }

            @Override
            public void setAttribute(String name, Object object) {
                from.setAttribute(name, object);
            }

            @Override
            public void removeAttribute(String name) {
                from.removeAttribute(name);
            }

            @Override
            public String getServletContextName() {
                return from.getServletContextName();
            }

            @Override
            public ServletRegistration.Dynamic addServlet(String servletName, String className) {
                return ServletRegistrationDynamicWrapper.fromJakartaServletRegistrationDynamic(from.addServlet(servletName, className));
            }

            @Override
            public ServletRegistration.Dynamic addServlet(String servletName, javax.servlet.Servlet servlet) {
                return ServletRegistrationDynamicWrapper.fromJakartaServletRegistrationDynamic(from.addServlet(servletName, ServletWrapper.toJakartaServlet(servlet)));
            }

            @Override
            public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends javax.servlet.Servlet> servletClass) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
                return ServletRegistrationDynamicWrapper.fromJakartaServletRegistrationDynamic(from.addJspFile(servletName, jspFile));
            }

            @Override
            public <T extends javax.servlet.Servlet> T createServlet(Class<T> clazz) {
                throw new UnsupportedOperationException();
            }

            @Override
            public javax.servlet.ServletRegistration getServletRegistration(String servletName) {
                return ServletRegistrationWrapper.fromJakartaServletRegistration(from.getServletRegistration(servletName));
            }

            @Override
            public Map<String, ? extends javax.servlet.ServletRegistration> getServletRegistrations() {
                return from.getServletRegistrations().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ServletRegistrationWrapper.fromJakartaServletRegistration((ServletRegistration)entry.getValue())));
            }

            @Override
            public FilterRegistration.Dynamic addFilter(String filterName, String className) {
                return FilterRegistrationDynamicWrapper.fromJakartaFilterRegistrationDynamic(from.addFilter(filterName, className));
            }

            @Override
            public FilterRegistration.Dynamic addFilter(String filterName, javax.servlet.Filter filter) {
                return FilterRegistrationDynamicWrapper.fromJakartaFilterRegistrationDynamic(from.addFilter(filterName, FilterWrapper.toJakartaFilter(filter)));
            }

            @Override
            public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends javax.servlet.Filter> filterClass) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T extends javax.servlet.Filter> T createFilter(Class<T> clazz) {
                throw new UnsupportedOperationException();
            }

            @Override
            public FilterRegistration getFilterRegistration(String filterName) {
                return FilterRegistrationWrapper.fromJakartaFilterRegistration(from.getFilterRegistration(filterName));
            }

            @Override
            public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
                return from.getFilterRegistrations().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> FilterRegistrationWrapper.fromJakartaFilterRegistration((jakarta.servlet.FilterRegistration)entry.getValue())));
            }

            @Override
            public javax.servlet.SessionCookieConfig getSessionCookieConfig() {
                return SessionCookieConfigWrapper.fromJakartaSessionCookieConfig(from.getSessionCookieConfig());
            }

            @Override
            public void setSessionTrackingModes(Set<javax.servlet.SessionTrackingMode> sessionTrackingModes) {
                from.setSessionTrackingModes(sessionTrackingModes.stream().map(SessionTrackingModeWrapper::toJakartaSessionTrackingMode).collect(Collectors.toSet()));
            }

            @Override
            public Set<javax.servlet.SessionTrackingMode> getDefaultSessionTrackingModes() {
                return from.getDefaultSessionTrackingModes().stream().map(SessionTrackingModeWrapper::fromJakartaSessionTrackingMode).collect(Collectors.toSet());
            }

            @Override
            public Set<javax.servlet.SessionTrackingMode> getEffectiveSessionTrackingModes() {
                return from.getEffectiveSessionTrackingModes().stream().map(SessionTrackingModeWrapper::fromJakartaSessionTrackingMode).collect(Collectors.toSet());
            }

            @Override
            public void addListener(String className) {
                from.addListener(className);
            }

            @Override
            public <T extends EventListener> void addListener(T t) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void addListener(Class<? extends EventListener> listenerClass) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T extends EventListener> T createListener(Class<T> clazz) {
                throw new UnsupportedOperationException();
            }

            @Override
            public javax.servlet.descriptor.JspConfigDescriptor getJspConfigDescriptor() {
                return JspConfigDescriptorWrapper.fromJakartaJspConfigDescriptor(from.getJspConfigDescriptor());
            }

            @Override
            public ClassLoader getClassLoader() {
                return from.getClassLoader();
            }

            @Override
            public void declareRoles(String ... roleNames) {
                from.declareRoles(roleNames);
            }

            @Override
            public String getVirtualServerName() {
                return from.getVirtualServerName();
            }

            @Override
            public int getSessionTimeout() {
                return from.getSessionTimeout();
            }

            @Override
            public void setSessionTimeout(int sessionTimeout) {
                from.setSessionTimeout(sessionTimeout);
            }

            @Override
            public String getRequestCharacterEncoding() {
                return from.getRequestCharacterEncoding();
            }

            @Override
            public void setRequestCharacterEncoding(String encoding) {
                from.setRequestCharacterEncoding(encoding);
            }

            @Override
            public String getResponseCharacterEncoding() {
                return from.getResponseCharacterEncoding();
            }

            @Override
            public void setResponseCharacterEncoding(String encoding) {
                from.setResponseCharacterEncoding(encoding);
            }
        };
    }
}

