/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.veracode.utils;

import com.veracode.apiwrapper.AbstractAPIWrapper;
import com.veracode.apiwrapper.wrapper.cli.exceptions.ApiException;
import com.veracode.apiwrapper.wrappers.ResultsAPIWrapper;
import com.veracode.apiwrapper.wrappers.SandboxAPIWrapper;
import com.veracode.apiwrapper.wrappers.UploadAPIWrapper;
import io.jenkins.plugins.veracode.data.ProxyBlock;
import io.jenkins.plugins.veracode.utils.StringUtil;
import io.jenkins.plugins.veracode.utils.XmlUtil;

public class WrapperUtil {
    public static final void setupCredential(AbstractAPIWrapper wrapper, String id, String key) {
        if (null == wrapper) {
            return;
        }
        wrapper.setUpApiCredentials(id, key);
    }

    public static final void setupProxy(AbstractAPIWrapper wrapper, ProxyBlock proxyInfo) {
        if (null == wrapper || null == proxyInfo) {
            return;
        }
        wrapper.setUpProxy(proxyInfo.getPhost(), proxyInfo.getPport(), proxyInfo.getPuser(), proxyInfo.getPpassword());
    }

    public static final String getBuildInfo(String appName, String sandboxName, String id, String key, ProxyBlock proxy) throws Exception {
        String buildInfoXml;
        String appListXml;
        String error;
        if (StringUtil.isNullOrEmpty(appName)) {
            throw new IllegalArgumentException("Application name is invalid.");
        }
        UploadAPIWrapper uploadApiWrapper = new UploadAPIWrapper();
        WrapperUtil.setupCredential((AbstractAPIWrapper)uploadApiWrapper, id, key);
        if (null != proxy) {
            WrapperUtil.setupProxy((AbstractAPIWrapper)uploadApiWrapper, proxy);
        }
        if (!StringUtil.isNullOrEmpty(error = XmlUtil.getErrorString(appListXml = uploadApiWrapper.getAppList()))) {
            throw new ApiException(error);
        }
        String appId = XmlUtil.parseAppId(appName, appListXml);
        if (StringUtil.isNullOrEmpty(appId)) {
            throw new ApiException(String.format("Cannot find the ID for application %s", appName));
        }
        String sandboxId = null;
        if (!StringUtil.isNullOrEmpty(sandboxName)) {
            String sandboxListXml = WrapperUtil.getSandboxList(appId, id, key, proxy);
            error = XmlUtil.getErrorString(sandboxListXml);
            if (!StringUtil.isNullOrEmpty(error)) {
                throw new ApiException(error);
            }
            sandboxId = XmlUtil.parseSandboxId(sandboxName, sandboxListXml);
            if (StringUtil.isNullOrEmpty(sandboxId)) {
                sandboxId = null;
            }
        }
        if (!StringUtil.isNullOrEmpty(error = XmlUtil.getErrorString(buildInfoXml = uploadApiWrapper.getBuildInfo(appId, null, sandboxId)))) {
            throw new ApiException(error);
        }
        return buildInfoXml;
    }

    public static final String getBuildInfoByAppIdBuildId(String appId, String buildId, String id, String key, ProxyBlock proxy) throws Exception {
        String buildInfoXml;
        String error;
        if (StringUtil.isNullOrEmpty(appId)) {
            throw new IllegalArgumentException("Application ID is invalid.");
        }
        if (StringUtil.isNullOrEmpty(buildId)) {
            throw new IllegalArgumentException("Build ID is invalid.");
        }
        UploadAPIWrapper uploadApiWrapper = new UploadAPIWrapper();
        WrapperUtil.setupCredential((AbstractAPIWrapper)uploadApiWrapper, id, key);
        if (null != proxy) {
            WrapperUtil.setupProxy((AbstractAPIWrapper)uploadApiWrapper, proxy);
        }
        if (!StringUtil.isNullOrEmpty(error = XmlUtil.getErrorString(buildInfoXml = uploadApiWrapper.getBuildInfo(appId, buildId)))) {
            throw new ApiException(error);
        }
        return buildInfoXml;
    }

    public static final String getDetailedReport(String buildId, String id, String key, ProxyBlock proxy) throws Exception {
        String detailedReportXml;
        String error;
        if (StringUtil.isNullOrEmpty(buildId)) {
            throw new IllegalArgumentException("Build ID is invalid.");
        }
        ResultsAPIWrapper resultsApiWrapper = new ResultsAPIWrapper();
        WrapperUtil.setupCredential((AbstractAPIWrapper)resultsApiWrapper, id, key);
        if (null != proxy) {
            WrapperUtil.setupProxy((AbstractAPIWrapper)resultsApiWrapper, proxy);
        }
        if (!StringUtil.isNullOrEmpty(error = XmlUtil.getErrorString(detailedReportXml = resultsApiWrapper.detailedReport(buildId)))) {
            throw new ApiException(error);
        }
        return detailedReportXml;
    }

    public static final String getSandboxList(String appId, String id, String key, ProxyBlock proxy) throws Exception {
        if (StringUtil.isNullOrEmpty(appId)) {
            throw new IllegalArgumentException("Application ID is invalid.");
        }
        SandboxAPIWrapper sandboxApiWrapper = new SandboxAPIWrapper();
        WrapperUtil.setupCredential((AbstractAPIWrapper)sandboxApiWrapper, id, key);
        if (null != proxy) {
            WrapperUtil.setupProxy((AbstractAPIWrapper)sandboxApiWrapper, proxy);
        }
        return sandboxApiWrapper.getSandboxList(appId);
    }

    public static final String getSummaryReport(String buildId, String id, String key, ProxyBlock proxy) throws Exception {
        String summaryReport;
        String error;
        if (StringUtil.isNullOrEmpty(buildId)) {
            throw new IllegalArgumentException("Build ID is invalid.");
        }
        ResultsAPIWrapper resultsApiWrapper = new ResultsAPIWrapper();
        WrapperUtil.setupCredential((AbstractAPIWrapper)resultsApiWrapper, id, key);
        if (null != proxy) {
            WrapperUtil.setupProxy((AbstractAPIWrapper)resultsApiWrapper, proxy);
        }
        if (!StringUtil.isNullOrEmpty(error = XmlUtil.getErrorString(summaryReport = resultsApiWrapper.summaryReport(buildId)))) {
            throw new ApiException(error);
        }
        return summaryReport;
    }
}

