/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.veracode.utils;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Node;
import java.util.List;

public final class RemoteScanUtil {
    public static int getJarVersion(String jarName) {
        String regex = ".*?vosp-api-wrappers-java-(.*?).jar";
        String temp = jarName.replaceAll(regex, "$1");
        String strVersion = temp.replaceAll("\\D", "");
        return Integer.parseInt(strVersion);
    }

    public static Integer[] getMaskPosition(List<String> remoteCmd) {
        Integer[] maskPos = new Integer[]{-1, -1, -1};
        int i = 0;
        for (String _cmd : remoteCmd) {
            if (_cmd.equals("-vkey")) {
                maskPos[1] = i + 1;
            } else if (_cmd.equals("-ppassword")) {
                maskPos[2] = i + 1;
            }
            ++i;
        }
        return maskPos;
    }

    public static String getPathSeparator(String remote) {
        if (remote.length() > 3 && remote.charAt(1) == ':' && remote.charAt(2) == '\\') {
            return "\\";
        }
        return "/";
    }

    public static FilePath getRemoteVeracodePath(AbstractBuild<?, ?> build) {
        Node node = build.getBuiltOn();
        if (node == null) {
            throw new RuntimeException("Cannot locate the build node.");
        }
        FilePath rootpath = node.getRootPath();
        if (rootpath == null) {
            throw new RuntimeException("Cannot retrieve the build node's root path.");
        }
        String remoteRootDir = rootpath.getRemote();
        String sep = RemoteScanUtil.getPathSeparator(remoteRootDir);
        String remoteDir = rootpath.getRemote() + sep + "veracode-jenkins-plugin";
        FilePath remoteVeracodeFilePath = new FilePath(node.getChannel(), remoteDir);
        return remoteVeracodeFilePath;
    }

    public static FilePath getRemoteVeracodePath(Node node) {
        FilePath rootpath = node.getRootPath();
        if (rootpath == null) {
            throw new RuntimeException("Cannot retieve the node's root path.");
        }
        String remoteRootDir = rootpath.getRemote();
        String sep = RemoteScanUtil.getPathSeparator(remoteRootDir);
        String remoteDir = rootpath.getRemote() + sep + "veracode-jenkins-plugin";
        FilePath remoteVeracodeFilePath = new FilePath(node.getChannel(), remoteDir);
        return remoteVeracodeFilePath;
    }

    public static String formatParameterValue(String parameterValue) {
        if (parameterValue.startsWith("\"") && parameterValue.endsWith("\"")) {
            return parameterValue;
        }
        return parameterValue.contains(" ") || parameterValue.contains("'") ? "\"" + parameterValue + "\"" : parameterValue;
    }
}

