/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.veracode.utils;

import com.veracode.apiwrapper.cli.VeracodeCommand;
import hudson.util.FormValidation;
import io.jenkins.plugins.veracode.args.GetAppListArgs;
import io.jenkins.plugins.veracode.data.ProxyBlock;
import io.jenkins.plugins.veracode.utils.EncryptionUtil;
import io.jenkins.plugins.veracode.utils.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public final class FormValidationUtil {
    private static final String DEFAULT_TIMEOUT = "60";
    private static final String ANALYSIS_NAME_DISPLAY_TEXT = "analysis name";
    private static final String ANALYSIS_NAME_REQUIRED_DISPLAY_TEXT = "Analysis Name";
    private static final int MINIMUM_LENGTH_FOR_DA_ANALYSIS_NAME = 6;
    private static final int MAXIMUM_LENGTH_FOR_DA_ANALYSIS_NAME = 190;
    private static final String DA_MAX_DURATION_DISPLAY_TEXT = "maximum duration";
    private static final String DA_MAX_RESULTS_DURATION_DISPLAY_TEXT = "wait for results duration";
    private static final int MINIMUM_VALUE_DA_MAX_DURATION_HOURS = 1;
    private static final int MAXIMUM_VALUE_DA_MAX_DURATION_HOURS = 600;
    private static final int MINIMUM_VALUE_DA_RESULTS_DURATION_HOURS = 0;
    private static final int MAXIMUM_VALUE_DA_RESULTS_DURATION_HOURS = 600;
    private static final String VID_DISPLAY_TEXT = "API ID";
    private static final String VKEY_DISPLAY_TEXT = "API Key";
    private static final String VID_IHELP_TEXT = "ID";
    private static final String VKEY_IHELP_TEXT = "key";

    public static FormValidation checkMutuallyInclusiveFields(String fieldValue, String dependencyFieldValue, String fieldDisplayName, String dependencyFieldDisplayName, String dependencyFieldIHelpTextName) {
        if (StringUtil.isNullOrEmpty(fieldValue) && !StringUtil.isNullOrEmpty(dependencyFieldValue)) {
            return FormValidation.error((String)String.format("%s is required.", fieldDisplayName));
        }
        if (!StringUtil.isNullOrEmpty(fieldValue) && StringUtil.isNullOrEmpty(dependencyFieldValue)) {
            if (dependencyFieldDisplayName.equals(VID_DISPLAY_TEXT) || dependencyFieldDisplayName.equals(VKEY_DISPLAY_TEXT)) {
                return FormValidation.warning((String)String.format("After entering your %s, you must also enter your %s in the %s field.", fieldDisplayName, dependencyFieldIHelpTextName, dependencyFieldDisplayName));
            }
            return FormValidation.warning((String)String.format("If %s is provided, %s must also be provided.", fieldDisplayName, dependencyFieldDisplayName));
        }
        return FormValidation.ok();
    }

    public static FormValidation checkFields(String fieldValue, String dependencyFieldValue, String fieldDisplayName, String dependencyFieldDisplayName, String dependencyFieldIHelpTextName) {
        if (StringUtil.isNullOrEmpty(fieldValue)) {
            return FormValidation.error((String)String.format("%s is required.", fieldDisplayName));
        }
        if (!StringUtil.isNullOrEmpty(fieldValue) && StringUtil.isNullOrEmpty(dependencyFieldValue)) {
            if (dependencyFieldDisplayName.equals(VID_DISPLAY_TEXT) || dependencyFieldDisplayName.equals(VKEY_DISPLAY_TEXT)) {
                return FormValidation.warning((String)String.format("After entering your %s, you must also enter your %s in the %s field.", fieldDisplayName, dependencyFieldIHelpTextName, dependencyFieldDisplayName));
            }
            return FormValidation.warning((String)String.format("If %s is provided, %s must also be provided.", fieldDisplayName, dependencyFieldDisplayName));
        }
        return FormValidation.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormValidation checkConnection(String id, String key, ProxyBlock proxy) {
        PrintStream ps = null;
        try {
            FormValidation formValidation;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ps = new PrintStream((OutputStream)baos, true, "UTF-8");
            VeracodeCommand.VeracodeParser parser = new VeracodeCommand.VeracodeParser();
            parser.throwExceptions(true);
            parser.setOutputWriter(null);
            parser.setErrorWriter(ps);
            GetAppListArgs appListArgs = GetAppListArgs.newGetAppListArgs(id, key, proxy);
            parser.parse(appListArgs.getArguments());
            String errorText = baos.toString("UTF-8");
            FormValidation formValidation2 = formValidation = !StringUtil.isNullOrEmpty(errorText) ? FormValidation.error((String)errorText) : FormValidation.ok((String)"Success!");
            if (ps != null) {
                ps.close();
            }
            return formValidation;
        }
        catch (Throwable throwable) {
            try {
                if (ps != null) {
                    ps.close();
                }
                throw throwable;
            }
            catch (Throwable e) {
                return FormValidation.error((String)FormValidationUtil.getApiWrapperExceptionMessage(e));
            }
        }
    }

    public static FormValidation checkAnalysisName(String analysisName) {
        if (StringUtil.isNullOrEmpty(analysisName)) {
            return FormValidation.error((String)String.format("%s is required.", ANALYSIS_NAME_REQUIRED_DISPLAY_TEXT));
        }
        int textLength = analysisName.trim().length();
        if (textLength < 6 || textLength > 190) {
            return FormValidation.error((String)String.format("Enter an %s of %s-%s characters.", ANALYSIS_NAME_DISPLAY_TEXT, 6, 190));
        }
        return FormValidation.ok();
    }

    public static FormValidation checkMaximumDuration(String maximumDuration) {
        if (!StringUtil.isNullOrEmpty(maximumDuration)) {
            try {
                int mxDurValue = Integer.parseInt(maximumDuration);
                return FormValidationUtil.checkMaximumDuration(mxDurValue) != null ? FormValidation.error((String)FormValidationUtil.checkMaximumDuration(mxDurValue)) : FormValidation.ok();
            }
            catch (NumberFormatException nfe) {
                return FormValidation.error((String)String.format("%s is not a valid number.", maximumDuration));
            }
        }
        return FormValidation.ok();
    }

    public static String checkMaximumDuration(int maximumDuration) {
        if (maximumDuration < 1 || maximumDuration > 600) {
            return String.format("Enter a %s of %s-%s hours.", DA_MAX_DURATION_DISPLAY_TEXT, 1, 600);
        }
        return null;
    }

    public static FormValidation checkWaitForResultsDuration(String waitForResultsDuration) {
        if (!StringUtil.isNullOrEmpty(waitForResultsDuration)) {
            try {
                int resultsDurValue = Integer.parseInt(waitForResultsDuration);
                return FormValidationUtil.checkWaitForResultsDuration(resultsDurValue) != null ? FormValidation.error((String)FormValidationUtil.checkWaitForResultsDuration(resultsDurValue)) : FormValidation.ok();
            }
            catch (NumberFormatException nfe) {
                return FormValidation.error((String)String.format("%s is not a valid number.", waitForResultsDuration));
            }
        }
        return FormValidation.ok();
    }

    public static String checkWaitForResultsDuration(int waitForResultsDuration) {
        if (waitForResultsDuration < 0 || waitForResultsDuration > 600) {
            return String.format("Enter a %s of up to %s hours (25 days).", DA_MAX_RESULTS_DURATION_DISPLAY_TEXT, 600);
        }
        return null;
    }

    public static FormValidation checkApiId(String vid, String vkey, boolean hasGlobalApiIdKeyCredentials) {
        if (hasGlobalApiIdKeyCredentials) {
            if (!StringUtil.isNullOrEmpty(vid) && !StringUtil.isNullOrEmpty(vkey)) {
                return FormValidation.warning((String)"These Veracode API credentials override the global Veracode API credentials.");
            }
            if (!StringUtil.isNullOrEmpty(vid) || !StringUtil.isNullOrEmpty(vkey)) {
                return FormValidationUtil.checkFields(vid, vkey, VID_DISPLAY_TEXT, VKEY_DISPLAY_TEXT, VKEY_DISPLAY_TEXT);
            }
            return FormValidationUtil.checkMutuallyInclusiveFields(vid, vkey, VID_DISPLAY_TEXT, VKEY_IHELP_TEXT, VKEY_DISPLAY_TEXT);
        }
        return FormValidationUtil.checkFields(vid, vkey, VID_DISPLAY_TEXT, VKEY_DISPLAY_TEXT, VKEY_DISPLAY_TEXT);
    }

    public static FormValidation checkApiKey(String vid, String vkey, boolean hasGlobalApiIdKeyCredentials) {
        if (hasGlobalApiIdKeyCredentials) {
            if (!StringUtil.isNullOrEmpty(vid) && !StringUtil.isNullOrEmpty(vkey)) {
                return FormValidation.warning((String)"These Veracode API credentials override the global Veracode API credentials.");
            }
            if (!StringUtil.isNullOrEmpty(vid) || !StringUtil.isNullOrEmpty(vkey)) {
                return FormValidationUtil.checkFields(vkey, vid, VKEY_DISPLAY_TEXT, VID_DISPLAY_TEXT, VID_DISPLAY_TEXT);
            }
            return FormValidationUtil.checkMutuallyInclusiveFields(vkey, vid, VKEY_DISPLAY_TEXT, VID_IHELP_TEXT, VID_DISPLAY_TEXT);
        }
        return FormValidationUtil.checkFields(vkey, vid, VKEY_DISPLAY_TEXT, VID_DISPLAY_TEXT, VID_DISPLAY_TEXT);
    }

    private static String getApiWrapperExceptionMessage(Throwable e) {
        if (e instanceof RuntimeException && e.getCause() != null) {
            e = e.getCause();
        }
        return e != null ? String.format("%s: %s", e.getClass().getName(), StringUtil.getEmptyIfNull(e.getMessage())) : "";
    }

    public static String formatTimeout(String timeoutValue) {
        String str_timeout = !StringUtil.isNullOrEmpty(EncryptionUtil.decrypt(timeoutValue)) && Integer.parseInt(EncryptionUtil.decrypt(timeoutValue)) >= 0 ? timeoutValue : DEFAULT_TIMEOUT;
        return str_timeout;
    }

    private FormValidationUtil() {
    }
}

