/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.veracode.enums;

public enum SeverityLevel {
    INFORMATIONAL(0),
    VERY_LOW(1),
    LOW(2),
    MEDIUM(3),
    HIGH(4),
    VERY_HIGH(5);

    private final int severityLevel;

    private SeverityLevel(int level) {
        this.severityLevel = level;
    }

    public static SeverityLevel findSevLevel(int level) {
        SeverityLevel[] allLevels = SeverityLevel.values();
        if (level < 0 || level >= allLevels.length) {
            throw new IllegalArgumentException("Invalid severity level.");
        }
        SeverityLevel result = null;
        for (SeverityLevel sl : allLevels) {
            if (sl.getSevLevel() != level) continue;
            result = sl;
            break;
        }
        return result;
    }

    public int getSevLevel() {
        return this.severityLevel;
    }

    public String toString() {
        String s = super.toString();
        String result = s.substring(0, 1) + (s.length() > 1 ? s.substring(1).toLowerCase() : "");
        return result.replace('_', ' ');
    }
}

