/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.veracode.data;

import io.jenkins.plugins.veracode.data.FindingCounts;
import io.jenkins.plugins.veracode.data.SCAComponent;
import io.jenkins.plugins.veracode.enums.SeverityLevel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SCAScanHistory {
    private final boolean subscribed;
    private final int blComponentsCount;
    private final double maxCVSSScore;
    private final List<Map<String, Long>> vulCountHistory;
    private final int totalVulCount;
    private final int totalNewVulCount;
    private final int totalNetVulCount;
    private final FindingCounts[] vulCounts;
    private final Set<SCAComponent> scaComponents;

    public SCAScanHistory() {
        this.subscribed = false;
        this.blComponentsCount = 0;
        this.maxCVSSScore = 0.0;
        this.vulCounts = null;
        this.scaComponents = null;
        this.vulCountHistory = null;
        this.totalVulCount = 0;
        this.totalNewVulCount = 0;
        this.totalNetVulCount = 0;
    }

    public SCAScanHistory(List<Map<String, Long>> vulCountHistory) {
        this.subscribed = false;
        this.blComponentsCount = 0;
        this.maxCVSSScore = 0.0;
        this.vulCounts = null;
        this.scaComponents = null;
        this.vulCountHistory = new ArrayList<Map<String, Long>>(vulCountHistory);
        this.totalVulCount = 0;
        this.totalNewVulCount = 0;
        this.totalNetVulCount = 0;
    }

    public SCAScanHistory(double maxCVSSScore, int blComponentsCount, Set<FindingCounts> vulCounts, Set<SCAComponent> scaComponents, List<Map<String, Long>> vulCountHistory) {
        this.subscribed = true;
        this.maxCVSSScore = maxCVSSScore;
        this.scaComponents = new HashSet<SCAComponent>(scaComponents);
        this.vulCounts = new FindingCounts[SeverityLevel.values().length];
        int totalVulCount = 0;
        int totalNewVulCount = 0;
        int totalNetVulCount = 0;
        for (FindingCounts vc : vulCounts) {
            if (null == vc || null != this.vulCounts[vc.getSevLevel().getSevLevel()]) continue;
            this.vulCounts[vc.getSevLevel().getSevLevel()] = vc;
            totalVulCount += vc.getCount();
            totalNewVulCount += vc.getNewCount();
            totalNetVulCount += vc.getNetCount();
        }
        this.totalVulCount = totalVulCount;
        this.totalNewVulCount = totalNewVulCount;
        this.totalNetVulCount = totalNetVulCount;
        this.blComponentsCount = blComponentsCount;
        this.vulCountHistory = new ArrayList<Map<String, Long>>(vulCountHistory);
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public int getBlacklistedComponentsCount() {
        return this.blComponentsCount;
    }

    public double getMaxCVSSScore() {
        return this.maxCVSSScore;
    }

    public Set<SCAComponent> getSCAComponents() {
        return new HashSet<SCAComponent>(this.scaComponents);
    }

    public FindingCounts getCountBySeverity(SeverityLevel sevLevel) {
        if (null == sevLevel) {
            throw new IllegalArgumentException("Must provide a severity level to get the finding counts.");
        }
        return this.vulCounts[sevLevel.getSevLevel()];
    }

    public int getTotalVulCount() {
        return this.totalVulCount;
    }

    public int getTotalNewVulCount() {
        return this.totalNewVulCount;
    }

    public int getTotalNetVulCount() {
        return this.totalNetVulCount;
    }

    public List<Map<String, Long>> getVulCountHistory() {
        return this.vulCountHistory;
    }

    public boolean hasVulCountHistory() {
        if (null == this.vulCountHistory) {
            return false;
        }
        boolean foundCountHistory = false;
        for (Map<String, Long> thisCountHistory : this.vulCountHistory) {
            if (null == thisCountHistory || null == thisCountHistory.get("FLAWS_COUNT")) continue;
            foundCountHistory = true;
            break;
        }
        return foundCountHistory;
    }
}

