/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.veracode.common;

import com.veracode.apiwrapper.dynamicanalysis.model.client.AnalysisInfo;
import com.veracode.apiwrapper.dynamicanalysis.model.client.AnalysisOccurrenceInfo;
import com.veracode.apiwrapper.dynamicanalysis.model.client.AnalysisOccurrenceStatusInfo;
import com.veracode.apiwrapper.dynamicanalysis.model.client.ScanOccurrenceInfo;
import com.veracode.apiwrapper.exceptions.ApiException;
import com.veracode.apiwrapper.services.APIServiceManager;
import com.veracode.apiwrapper.services.DynamicAnalysisAPIService;
import com.veracode.parser.enums.CredentialTypes;
import com.veracode.parser.util.XmlUtils;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.veracode.DynamicAnalysisResultsAction;
import io.jenkins.plugins.veracode.common.Constant;
import io.jenkins.plugins.veracode.data.DAScanHistory;
import io.jenkins.plugins.veracode.data.ProxyBlock;
import io.jenkins.plugins.veracode.utils.FileUtil;
import io.jenkins.plugins.veracode.utils.FormValidationUtil;
import io.jenkins.plugins.veracode.utils.StringUtil;
import io.jenkins.plugins.veracode.utils.WrapperUtil;
import io.jenkins.plugins.veracode.utils.XmlUtil;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.w3c.dom.Node;

public class DAAdapterService {
    private static final String PARAM_DA_ANALYSIS_NAME = "DA_ANALYSIS_NAME";
    private static final String PARAM_DA_PREVIOUS_OCCURRENCE_ID = "DA_PREVIOUS_OCCURRENCE_ID";
    private static final short GET_DA_SLEEP_TIME_MINUTES = 5;
    private static final short MAX_ALLOWED_CONSECUTIVE_API_EXCEPTIONS = 5;

    public boolean resubmitDynamicAnalysis(Run<?, ?> run, FilePath workspace, TaskListener listener, String analysisName, int maximumDuration, boolean failBuildAsScanFailed, String apiID, String apiKey, boolean debugEnabled, ProxyBlock proxyBlock) {
        try {
            this.log(listener, Constant.STARTING_POST_BUILD_ACTION_LOG, "Resubmit Veracode Dynamic Analysis");
            if (debugEnabled) {
                this.log(listener, "[Debug mode is on]", new Object[0]);
                this.showHPILocation(listener);
            }
            if (!FileUtil.cleanUpBuildProperties(run, listener)) {
                this.log(listener, "Failed to clean up previous build properties.", new Object[0]);
                return !failBuildAsScanFailed;
            }
            this.log(listener, "Project: %s" + Constant.NEWLINE + "Dynamic Analysis name: %s" + Constant.NEWLINE + "Maximum duration (in hours): %s" + Constant.NEWLINE + "Fail the build if the analysis fails: %s" + Constant.NEWLINE + "Use proxy: %s", workspace, analysisName, maximumDuration, failBuildAsScanFailed, String.valueOf(proxyBlock != null));
            if (!this.validateUserInputsForResubmit(apiID, apiKey, analysisName, maximumDuration, listener)) {
                return !failBuildAsScanFailed;
            }
            Proxy proxy = this.setupProxy(proxyBlock, listener);
            if (proxy == null) {
                return !failBuildAsScanFailed;
            }
            DynamicAnalysisAPIService daApiService = APIServiceManager.createInstance((CredentialTypes)CredentialTypes.API, (String)apiID, (String)apiKey, (Proxy)proxy).getDynamicAnalysisAPIService();
            AnalysisInfo analysisInfo = this.getAnalysisInfo(daApiService, analysisName, listener);
            if (analysisInfo == null || StringUtil.isNullOrEmpty(analysisInfo.getAnalysisId())) {
                this.logWithTimeStamp(listener, "Resubmit failed. Preconfigured dynamic analysis not found.", new Object[0]);
                return !failBuildAsScanFailed;
            }
            if (!this.resubmitAnalysis(daApiService, analysisInfo, maximumDuration, listener)) {
                return !failBuildAsScanFailed;
            }
            Properties properties = new Properties();
            properties.setProperty(PARAM_DA_ANALYSIS_NAME, analysisInfo.getAnalysisName());
            if (!StringUtil.isNullOrEmpty(analysisInfo.getAnalysisOccurrenceId())) {
                properties.setProperty(PARAM_DA_PREVIOUS_OCCURRENCE_ID, analysisInfo.getAnalysisOccurrenceId());
            }
            FileUtil.createBuildPropertiesFile(run, properties, listener);
            this.log(listener, "Finished Post Build Action: %s", "Resubmit Veracode Dynamic Analysis");
            return true;
        }
        catch (Exception e) {
            this.logWithTimeStamp(listener, "Resubmit failed. Unexpected error occurred: %s" + Constant.NEWLINE, e.getMessage());
            return !failBuildAsScanFailed;
        }
    }

    private boolean validateUserInputsForResubmit(String apiID, String apiKey, String analysisName, int maximumDuration, TaskListener listener) {
        if (StringUtil.isNullOrEmpty(apiID) || StringUtil.isNullOrEmpty(apiKey)) {
            this.log(listener, "No dynamic analysis submitted. Required API ID and key credentials not provided." + Constant.NEWLINE, new Object[0]);
            return false;
        }
        if (StringUtil.isNullOrEmpty(analysisName)) {
            this.log(listener, "Dynamic analysis name is empty", new Object[0]);
            return false;
        }
        if (FormValidationUtil.checkMaximumDuration(maximumDuration) != null) {
            this.log(listener, FormValidationUtil.checkMaximumDuration(maximumDuration) + Constant.NEWLINE, new Object[0]);
            return false;
        }
        return true;
    }

    private AnalysisInfo getAnalysisInfo(DynamicAnalysisAPIService daApiService, String analysisName, TaskListener listener) {
        try {
            return daApiService.getAnalysisByName(analysisName);
        }
        catch (ApiException e) {
            this.logWithTimeStamp(listener, "Resubmit failed. Error retrieving analysis information, server returned HTTP response code: " + e.getResponseCode(), new Object[0]);
            this.logErrorResponse(e.getResponseCode(), listener);
            return null;
        }
        catch (Exception e) {
            this.logWithTimeStamp(listener, "Resubmit failed. Error retrieving analysis information: %s", e.getMessage());
            return null;
        }
    }

    private boolean resubmitAnalysis(DynamicAnalysisAPIService daApiService, AnalysisInfo analysisInfo, int maximumDuration, TaskListener listener) {
        try {
            daApiService.resubmitAnalysisById(analysisInfo.getAnalysisId(), maximumDuration);
            this.logWithTimeStamp(listener, "Resubmitting dynamic analysis for '%s' with duration %s hour(s).", analysisInfo.getAnalysisName(), maximumDuration);
            this.logWithTimeStamp(listener, "Resubmit succeeded.", new Object[0]);
            return true;
        }
        catch (ApiException e) {
            this.logWithTimeStamp(listener, "Resubmit failed. Error submitting dynamic analysis, server returned HTTP response code: " + e.getResponseCode(), new Object[0]);
            this.logErrorResponse(e.getResponseCode(), listener);
            this.logWithTimeStamp(listener, "Analysis status for '%s' is %s", analysisInfo.getAnalysisName(), analysisInfo.getStatusInfo().getStatus() + Constant.NEWLINE);
            return false;
        }
        catch (Exception e) {
            this.logWithTimeStamp(listener, "Resubmit failed. Unexpected error submitting dynamic analysis: %s", e.getMessage());
            this.logWithTimeStamp(listener, "Analysis Status: %s", analysisInfo.getStatusInfo().getStatus() + Constant.NEWLINE);
            return false;
        }
    }

    public boolean reviewDynamicAnalysis(Run<?, ?> build, FilePath workspace, TaskListener listener, int waitForResultsDuration, boolean failBuildForPolicyViolation, String apiID, String apiKey, boolean debugEnabled, ProxyBlock proxyBlock) {
        this.log(listener, Constant.STARTING_POST_BUILD_ACTION_LOG, "Review Veracode Dynamic Analysis Results");
        long expirationResultsWaitTime = System.currentTimeMillis() + TimeUnit.HOURS.toMillis(waitForResultsDuration);
        try {
            Properties veracodeProps;
            if (debugEnabled) {
                this.log(listener, "[Debug mode is on]", new Object[0]);
                this.showHPILocation(listener);
            }
            if ((veracodeProps = FileUtil.readBuildPropertiesFile(build, listener)) == null || veracodeProps.isEmpty()) {
                this.log(listener, "Failed to retrieve dynamic analysis info from resubmit dynamic analysis step.", new Object[0]);
                return false;
            }
            this.log(listener, "Project: %s" + Constant.NEWLINE + "Dynamic Analysis name: %s" + Constant.NEWLINE + "Results wait time (in hours): %s" + Constant.NEWLINE + "Fail the build for policy violation: %s" + Constant.NEWLINE + "Use proxy: %s", workspace, veracodeProps.getProperty(PARAM_DA_ANALYSIS_NAME), waitForResultsDuration, failBuildForPolicyViolation, String.valueOf(proxyBlock != null));
            if (!this.validateUserInputsForReview(apiID, apiKey, veracodeProps.getProperty(PARAM_DA_ANALYSIS_NAME), waitForResultsDuration, listener)) {
                build.addAction((Action)new DynamicAnalysisResultsAction());
                return false;
            }
            Proxy proxy = this.setupProxy(proxyBlock, listener);
            if (proxy == null) {
                build.addAction((Action)new DynamicAnalysisResultsAction());
                return false;
            }
            DynamicAnalysisAPIService daApiService = APIServiceManager.createInstance((CredentialTypes)CredentialTypes.API, (String)apiID, (String)apiKey, (Proxy)proxy).getDynamicAnalysisAPIService();
            this.log(listener, "Requesting dynamic analysis results for '%s' with results wait time duration of %s hour(s).", veracodeProps.getProperty(PARAM_DA_ANALYSIS_NAME), waitForResultsDuration);
            ScanOccurrenceInfo scanOccurrenceInfo = null;
            try {
                String currentOccurrenceId = this.determineAnalysisOccurrenceId(daApiService, veracodeProps.getProperty(PARAM_DA_ANALYSIS_NAME), veracodeProps.getProperty(PARAM_DA_PREVIOUS_OCCURRENCE_ID), expirationResultsWaitTime, listener);
                if (StringUtil.isNullOrEmpty(currentOccurrenceId)) {
                    this.logWithTimeStamp(listener, "Timeout waiting for dynamic analysis to initiate.", new Object[0]);
                    build.addAction((Action)new DynamicAnalysisResultsAction());
                    return false;
                }
                boolean isAnalysisFinished = false;
                isAnalysisFinished = this.waitForAnalysisToComplete(daApiService, currentOccurrenceId, expirationResultsWaitTime, listener);
                if (!isAnalysisFinished) {
                    this.logWithTimeStamp(listener, "Timeout waiting for dynamic analysis to complete and publish results.", new Object[0]);
                    build.addAction((Action)new DynamicAnalysisResultsAction());
                    return false;
                }
                scanOccurrenceInfo = this.getLinkedAnalysisResults(daApiService, currentOccurrenceId, expirationResultsWaitTime, listener);
                if (null == scanOccurrenceInfo) {
                    this.logWithTimeStamp(listener, "Timeout waiting for dynamic analysis link results.", new Object[0]);
                    build.addAction((Action)new DynamicAnalysisResultsAction());
                    return false;
                }
            }
            catch (InterruptedException e) {
                this.logWithTimeStamp(listener, "Interrupted exception handling dynamic analysis action.", new Object[0]);
                build.addAction((Action)new DynamicAnalysisResultsAction());
                e.printStackTrace();
                return false;
            }
            catch (RuntimeException e) {
                this.logWithTimeStamp(listener, "Runtime exception error handling dynamic analyis action: %s", e.getMessage());
                e.printStackTrace();
                build.addAction((Action)new DynamicAnalysisResultsAction());
                return false;
            }
            catch (Exception e) {
                this.logWithTimeStamp(listener, "Exception handling dynamic analysis action: %s", e.getMessage());
                e.printStackTrace();
                build.addAction((Action)new DynamicAnalysisResultsAction());
                return false;
            }
            String policyRulesStatus = "Pass";
            try {
                boolean isBuildReady = this.waitForBuildReady(scanOccurrenceInfo, apiID, apiKey, proxyBlock, expirationResultsWaitTime, listener);
                if (!isBuildReady) {
                    this.log(listener, "Timeout waiting for dynamic analysis link results.", new Object[0]);
                    build.addAction((Action)new DynamicAnalysisResultsAction());
                    return false;
                }
                String detailedReportXML = WrapperUtil.getDetailedReport(scanOccurrenceInfo.getLinkedAppData().getBuildId(), apiID, apiKey, proxyBlock);
                DAScanHistory daScanHistory = XmlUtil.newDAScanHistory(detailedReportXML, scanOccurrenceInfo, build);
                policyRulesStatus = daScanHistory.getPolicyComplianceStatus();
                this.log(listener, Constant.NEWLINE + "The Dynamic Analysis finished with policy rule status: %s", policyRulesStatus + Constant.NEWLINE);
                build.addAction((Action)new DynamicAnalysisResultsAction(daScanHistory));
            }
            catch (ApiException e) {
                this.logWithTimeStamp(listener, "API exception while waiting for Dynamic Analysis linking results status.", new Object[0]);
                build.addAction((Action)new DynamicAnalysisResultsAction());
                return false;
            }
            catch (InterruptedException e) {
                this.logWithTimeStamp(listener, "Interrupted exception handling dynamic analysis linking results action.", new Object[0]);
                build.addAction((Action)new DynamicAnalysisResultsAction());
                e.printStackTrace();
                return false;
            }
            catch (RuntimeException e) {
                this.logWithTimeStamp(listener, "Runtime exception error handling dynamic analyis linking results action: %s", e.getMessage());
                e.printStackTrace();
                build.addAction((Action)new DynamicAnalysisResultsAction());
                return false;
            }
            this.log(listener, "Finished Post Build Action: %s", "Review Veracode Dynamic Analysis Results");
            return policyRulesStatus.equalsIgnoreCase("Pass") ? true : !failBuildForPolicyViolation;
        }
        catch (Exception e) {
            this.log(listener, "Unexpected error occurred: %s" + Constant.NEWLINE, e.getMessage());
            build.addAction((Action)new DynamicAnalysisResultsAction());
            return false;
        }
    }

    private boolean validateUserInputsForReview(String apiID, String apiKey, String analysisName, int waitForResultsDuration, TaskListener listener) {
        if (StringUtil.isNullOrEmpty(apiID) || StringUtil.isNullOrEmpty(apiKey)) {
            this.log(listener, "Error requesting Dynamic Analysis results - required API ID and key credentials not provided", new Object[0]);
            return false;
        }
        if (FormValidationUtil.checkWaitForResultsDuration(waitForResultsDuration) != null) {
            this.log(listener, "Error requesting Dynamic Analysis results.", new Object[0]);
            this.log(listener, FormValidationUtil.checkWaitForResultsDuration(waitForResultsDuration) + Constant.NEWLINE, new Object[0]);
            return false;
        }
        if (StringUtil.isNullOrEmpty(analysisName)) {
            this.log(listener, "Error requesting Dynamic Analysis results - Dynamic Analysis scan name is unknown.", new Object[0]);
            this.log(listener, "Verify Resubmit Veracode Dynamic Analysis post build action ran successfully in this Jenkins build prior to requesting results." + Constant.NEWLINE, new Object[0]);
            return false;
        }
        return true;
    }

    private String determineAnalysisOccurrenceId(DynamicAnalysisAPIService daApiService, String analysisName, String previousOccurrenceId, long expirationResultsWaitTime, TaskListener listener) throws Exception {
        String currentOccurrenceId = "";
        boolean isAnalysisCreated = false;
        boolean isTimeToQuit = false;
        int exceptionCount = 0;
        while (!isAnalysisCreated && !isTimeToQuit) {
            try {
                AnalysisInfo analysisInfo = daApiService.getAnalysisByName(analysisName);
                String string = currentOccurrenceId = analysisInfo != null ? analysisInfo.getAnalysisOccurrenceId() : null;
                if (StringUtil.isNullOrEmpty(currentOccurrenceId) || currentOccurrenceId.equals(previousOccurrenceId)) {
                    this.logWithTimeStamp(listener, "Dynamic analysis not yet initiated. Check in %s minutes.", (short)5);
                    Thread.sleep(TimeUnit.MINUTES.toMillis(5L));
                } else {
                    isAnalysisCreated = true;
                }
                isTimeToQuit = this.isWaitTimeDurationExpired(expirationResultsWaitTime);
                exceptionCount = 0;
            }
            catch (ApiException e) {
                this.log(listener, "API exception error waiting for dynamic analysis to initiate. Server returned HTTP response code: " + e.getResponseCode(), new Object[0]);
                this.logErrorResponse(e.getResponseCode(), listener);
                if (500 == e.getResponseCode() || 504 == e.getResponseCode()) {
                    if (++exceptionCount == 5 || this.isWaitTimeDurationExpired(expirationResultsWaitTime)) {
                        isTimeToQuit = true;
                        continue;
                    }
                    this.logWithTimeStamp(listener, "Retry checking if dynamic analysis initiated in %s minutes.", (short)5);
                    Thread.sleep(TimeUnit.MINUTES.toMillis(5L));
                    isTimeToQuit = this.isWaitTimeDurationExpired(expirationResultsWaitTime);
                    continue;
                }
                isTimeToQuit = true;
            }
        }
        return currentOccurrenceId;
    }

    private boolean waitForAnalysisToComplete(DynamicAnalysisAPIService daApiService, String currentOccurrenceId, long expirationResultsWaitTime, TaskListener listener) throws Exception {
        AnalysisOccurrenceInfo analysisOccurrenceInfo = null;
        boolean isTimeToQuit = false;
        boolean isAnalysisFinished = false;
        int exceptionCount = 0;
        while (!isAnalysisFinished && !isTimeToQuit) {
            try {
                analysisOccurrenceInfo = daApiService.getLatestAnalysisOccurrence(currentOccurrenceId);
                exceptionCount = 0;
                if (analysisOccurrenceInfo == null) {
                    this.logWithTimeStamp(listener, "Dynamic analysis occurrence not found. Check in %s minutes.", (short)5);
                    Thread.sleep(TimeUnit.MINUTES.toMillis(5L));
                    isTimeToQuit = this.isWaitTimeDurationExpired(expirationResultsWaitTime);
                    continue;
                }
                AnalysisOccurrenceStatusInfo.StatusTypeEnum analysisStatus = analysisOccurrenceInfo.getAnalysisStatus().getStatus();
                if (analysisStatus != null && analysisStatus.equals((Object)AnalysisOccurrenceStatusInfo.StatusTypeEnum.FINISHED_RESULTS_AVAILABLE)) {
                    isAnalysisFinished = true;
                    this.logWithTimeStamp(listener, "The status of the dynamic analysis is: %s", analysisStatus);
                    this.logWithTimeStamp(listener, "The dynamic analysis finished with occurrence id: %s", currentOccurrenceId);
                    this.logWithTimeStamp(listener, "The next step is linking the analysis to the application for policy evaluation.", new Object[0]);
                    continue;
                }
                if (analysisStatus != null && (analysisStatus.equals((Object)AnalysisOccurrenceStatusInfo.StatusTypeEnum.VERIFICATION_FAILED) || analysisStatus.equals((Object)AnalysisOccurrenceStatusInfo.StatusTypeEnum.STOPPED) || analysisStatus.equals((Object)AnalysisOccurrenceStatusInfo.StatusTypeEnum.STOPPED_TIME) || analysisStatus.equals((Object)AnalysisOccurrenceStatusInfo.StatusTypeEnum.STOPPED_TIME_VERIFYING_RESULTS) || analysisStatus.equals((Object)AnalysisOccurrenceStatusInfo.StatusTypeEnum.STOPPED_TECHNICAL_ISSUE) || analysisStatus.equals((Object)AnalysisOccurrenceStatusInfo.StatusTypeEnum.STOPPED_VERIFYING_RESULTS_BY_USER) || analysisStatus.equals((Object)AnalysisOccurrenceStatusInfo.StatusTypeEnum.STOPPED_VERIFYING_RESULTS))) {
                    this.logWithTimeStamp(listener, "The dynamic analysis failed to complete with status: %s", analysisStatus);
                    isTimeToQuit = true;
                    continue;
                }
                this.logWithTimeStamp(listener, "The status of the dynamic analysis is: %s" + Constant.NEWLINE + DAAdapterService.timestamp() + "Requesting status in %s minutes", analysisStatus, (short)5);
                Thread.sleep(TimeUnit.MINUTES.toMillis(5L));
                isTimeToQuit = this.isWaitTimeDurationExpired(expirationResultsWaitTime);
            }
            catch (ApiException e) {
                this.log(listener, "API exception error retrieving scan analysis status. Server returned HTTP response code: " + e.getResponseCode(), new Object[0]);
                this.logErrorResponse(e.getResponseCode(), listener);
                if (500 == e.getResponseCode() || 504 == e.getResponseCode()) {
                    if (++exceptionCount == 5 || this.isWaitTimeDurationExpired(expirationResultsWaitTime)) {
                        isTimeToQuit = true;
                        continue;
                    }
                    this.logWithTimeStamp(listener, "Retry requesting scan occurrence info in %s minutes.", (short)5);
                    Thread.sleep(TimeUnit.MINUTES.toMillis(5L));
                    isTimeToQuit = this.isWaitTimeDurationExpired(expirationResultsWaitTime);
                    continue;
                }
                isTimeToQuit = true;
            }
        }
        return isAnalysisFinished;
    }

    private ScanOccurrenceInfo getLinkedAnalysisResults(DynamicAnalysisAPIService daApiService, String occurrenceId, long expirationResultsWaitTime, TaskListener listener) throws Exception {
        boolean isLinkedAppInfoReady = false;
        boolean isTimeToQuit = false;
        int exceptionCount = 0;
        ScanOccurrenceInfo scanOccurrenceResultsInfo = null;
        while (!isLinkedAppInfoReady && !isTimeToQuit) {
            try {
                Set scanOccurrenceInfoSet = daApiService.getScanOccurrences(occurrenceId);
                if (scanOccurrenceInfoSet != null && !scanOccurrenceInfoSet.isEmpty()) {
                    if (scanOccurrenceInfoSet.size() > 1) {
                        throw new RuntimeException("Multiple scan occurrences found.");
                    }
                    scanOccurrenceResultsInfo = (ScanOccurrenceInfo)scanOccurrenceInfoSet.toArray()[0];
                }
                exceptionCount = 0;
                if (scanOccurrenceResultsInfo != null) {
                    if (StringUtil.isNullOrEmpty(scanOccurrenceResultsInfo.getLinkedPlatformAppId())) {
                        this.logWithTimeStamp(listener, "Review results failed. Linked application is unknown.", new Object[0]);
                        this.logWithTimeStamp(listener, "Verify dynamic analysis is linked to an application.", new Object[0]);
                        return null;
                    }
                    if (null != scanOccurrenceResultsInfo.getLinkedAppData() && !StringUtil.isNullOrEmpty(scanOccurrenceResultsInfo.getLinkedAppData().getBuildId())) {
                        isLinkedAppInfoReady = true;
                        this.logWithTimeStamp(listener, "The linked application is: %s (appid=%s)", scanOccurrenceResultsInfo.getLinkedPlatformAppName(), scanOccurrenceResultsInfo.getLinkedPlatformAppId());
                        this.logWithTimeStamp(listener, "The linked application build ID is: %s", scanOccurrenceResultsInfo.getLinkedAppData().getBuildId());
                    } else {
                        this.logWithTimeStamp(listener, "Build id is not available." + Constant.NEWLINE + DAAdapterService.timestamp() + "Requesting build id again in %s minute(s).", (short)5);
                        Thread.sleep(TimeUnit.MINUTES.toMillis(5L));
                    }
                    if (!(isTimeToQuit = this.isWaitTimeDurationExpired(expirationResultsWaitTime))) continue;
                    return null;
                }
                this.logWithTimeStamp(listener, "Error getting linked application data", new Object[0]);
                return null;
            }
            catch (ApiException e) {
                this.log(listener, "API exception error retrieving scan occurrence info. Server returned HTTP response code: " + e.getResponseCode(), new Object[0]);
                this.logErrorResponse(e.getResponseCode(), listener);
                if (500 == e.getResponseCode() || 504 == e.getResponseCode()) {
                    if (++exceptionCount == 5 || this.isWaitTimeDurationExpired(expirationResultsWaitTime)) {
                        isTimeToQuit = true;
                        continue;
                    }
                    this.logWithTimeStamp(listener, "Retry requesting scan occurrence info in %s minutes.", (short)5);
                    Thread.sleep(TimeUnit.MINUTES.toMillis(5L));
                    isTimeToQuit = this.isWaitTimeDurationExpired(expirationResultsWaitTime);
                    continue;
                }
                isTimeToQuit = true;
            }
        }
        return scanOccurrenceResultsInfo;
    }

    private boolean waitForBuildReady(ScanOccurrenceInfo scanOccurrenceInfo, String apiID, String apiKey, ProxyBlock proxyBlock, long expirationResultsWaitTime, TaskListener listener) throws Exception {
        boolean isBuildReady = false;
        boolean isTimeToQuit = false;
        int exceptionCount = 0;
        this.logWithTimeStamp(listener, "Requesting dynamic analysis linked results", new Object[0]);
        while (!isBuildReady && !isTimeToQuit) {
            try {
                String buildInfo = WrapperUtil.getBuildInfoByAppIdBuildId(scanOccurrenceInfo.getLinkedPlatformAppId(), scanOccurrenceInfo.getLinkedAppData().getBuildId(), apiID, apiKey, proxyBlock);
                if (!StringUtil.isNullOrEmpty(buildInfo)) {
                    Node nodeAnalysisUnit = XmlUtils.getXmlNode((String)buildInfo, (String)"/*/*/*[local-name()='analysis_unit']");
                    String buildStatus = nodeAnalysisUnit.getAttributes().getNamedItem("status").getNodeValue();
                    if (buildStatus != null && buildStatus.equalsIgnoreCase("Results Ready")) {
                        this.logWithTimeStamp(listener, "Dynamic analysis linking is complete with status: %s", buildStatus);
                        isBuildReady = true;
                    } else {
                        this.logWithTimeStamp(listener, "The linking status of the dynamic analysis is: %s" + Constant.NEWLINE + DAAdapterService.timestamp() + "Requesting linking status in %s minutes", buildStatus, (short)5);
                        Thread.sleep(TimeUnit.MINUTES.toMillis(5L));
                        isTimeToQuit = this.isWaitTimeDurationExpired(expirationResultsWaitTime);
                    }
                } else {
                    this.logWithTimeStamp(listener, "Error getting build info after analysis linked", new Object[0]);
                    isTimeToQuit = true;
                }
                exceptionCount = 0;
            }
            catch (ApiException e) {
                this.log(listener, "API exception error retrieving linked results status. Server returned HTTP response code: " + e.getResponseCode(), new Object[0]);
                this.logErrorResponse(e.getResponseCode(), listener);
                if (500 == e.getResponseCode() || 504 == e.getResponseCode()) {
                    if (++exceptionCount == 5 || this.isWaitTimeDurationExpired(expirationResultsWaitTime)) {
                        isTimeToQuit = true;
                        continue;
                    }
                    this.logWithTimeStamp(listener, "Retry requesting linked status in %s minutes.", (short)5);
                    Thread.sleep(TimeUnit.MINUTES.toMillis(5L));
                    isTimeToQuit = this.isWaitTimeDurationExpired(expirationResultsWaitTime);
                    continue;
                }
                isTimeToQuit = true;
            }
        }
        return isBuildReady;
    }

    private boolean isWaitTimeDurationExpired(long expirationResultsWaitTime) {
        return System.currentTimeMillis() > expirationResultsWaitTime;
    }

    private void showHPILocation(TaskListener listener) {
        try {
            String location = this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
            if (!StringUtil.isNullOrEmpty(location)) {
                this.log(listener, "HPI location: ", new Object[0]);
                location = location.replace("file:/", "");
                listener.hyperlink("file://" + location, location);
            }
        }
        catch (Exception e) {
            this.log(listener, "Could not retrieve hpi file directory.", new Object[0]);
        }
    }

    private Proxy setupProxy(final ProxyBlock proxyBlock, TaskListener listener) {
        try {
            if (proxyBlock == null) {
                return Proxy.NO_PROXY;
            }
            if (StringUtil.isNullOrEmpty(proxyBlock.getPhost()) || StringUtil.isNullOrEmpty(proxyBlock.getPport())) {
                this.log(listener, "Proxy is enabled, but the host or port is empty", new Object[0]);
                return null;
            }
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyBlock.getPhost(), Integer.parseInt(proxyBlock.getPport())));
            if (!StringUtil.isNullOrEmpty(proxyBlock.getPuser()) && !StringUtil.isNullOrEmpty(proxyBlock.getPpassword())) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxyBlock.getPuser(), proxyBlock.getPpassword().toCharArray());
                    }
                });
            }
            return proxy;
        }
        catch (NumberFormatException e) {
            this.log(listener, "Invalid port number for proxy", new Object[0]);
            return null;
        }
        catch (Exception e) {
            this.log(listener, "Failed to setup proxy", new Object[0]);
            return null;
        }
    }

    private final void log(TaskListener listener, String format, Object ... args) {
        listener.getLogger().printf(Constant.NEWLINE + format + Constant.NEWLINE, args);
    }

    private final void logWithTimeStamp(TaskListener listener, String format, Object ... args) {
        listener.getLogger().printf(Constant.NEWLINE + DAAdapterService.timestamp() + format, args);
        listener.getLogger().printf(Constant.NEWLINE + DAAdapterService.timestamp(), new Object[0]);
    }

    private static String timestamp() {
        return String.format("[%s] ", new SimpleDateFormat("yy.MM.dd HH:mm:ss").format(new Date()));
    }

    private final void logErrorResponse(int responseCode, TaskListener listener) {
        if (responseCode == 401) {
            this.log(listener, Constant.AUTHENTICATION_ERROR, new Object[0]);
        } else if (responseCode == 403) {
            this.log(listener, "Please verify the account is configured with sufficient privilege.", new Object[0]);
        } else if (responseCode == 500) {
            this.log(listener, "Internal Server Error", new Object[0]);
        } else if (responseCode == 504) {
            this.log(listener, "Gateway Timeout Error", new Object[0]);
        }
    }
}

