/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.veracode.args;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import io.jenkins.plugins.veracode.VeracodeNotifier;
import io.jenkins.plugins.veracode.args.AbstractArgs;
import io.jenkins.plugins.veracode.utils.FileUtil;
import io.jenkins.plugins.veracode.utils.StringUtil;
import io.jenkins.plugins.veracode.utils.UserAgentUtil;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class UploadAndScanArgs
extends AbstractArgs {
    private static final String APPNAME = "-appname";
    private static final String DESCRIPTION = "-description";
    private static final String CREATEPROFILE = "-createprofile";
    private static final String TEAMS = "-teams";
    private static final String CRITICALITY = "-criticality";
    private static final String SANDBOXNAME = "-sandboxname";
    private static final String CREATESANDBOX = "-createsandbox";
    private static final String VERSION = "-version";
    private static final String INCLUDE = "-include";
    private static final String EXCLUDE = "-exclude";
    private static final String AUTOSCAN = "-autoscan";
    private static final String PATTERN = "-pattern";
    private static final String REPLACEMENT = "-replacement";
    private static final String FILEPATH = "-filepath";
    private static final String TIMEOUT = "-scantimeout";
    private static final String MAXRETRYCOUNT = "-maxretrycount";
    private static final String CUSTOM_TIMESTAMP_VAR = "timestamp";
    private static final String CUSTOM_BUILD_NUMBER_VAR = "buildnumber";
    public static final String CUSTOM_PROJECT_NAME_VAR = "projectname";

    private UploadAndScanArgs() {
        this.addAction("UploadAndScan");
    }

    private void addStdArguments(boolean bRemoteScan, String appname, String description, boolean createprofile, String teams, String criticality, String sandboxname, boolean createsandbox, String version, String include, String exclude, String pattern, String replacement, String timeOut, String ... filepath) {
        if (bRemoteScan && !StringUtil.isNullOrEmpty(timeOut)) {
            this.list.add(TIMEOUT);
            this.list.add(timeOut);
        }
        this.addStdArguments(appname, description, createprofile, teams, criticality, sandboxname, createsandbox, version, include, exclude, pattern, replacement, filepath);
    }

    private void addStdArguments(String appname, String description, boolean createprofile, String teams, String criticality, String sandboxname, boolean createsandbox, String version, String include, String exclude, String pattern, String replacement, String ... filepath) {
        if (!StringUtil.isNullOrEmpty(appname)) {
            this.list.add(APPNAME);
            this.list.add(appname);
            this.list.add(CREATEPROFILE);
            this.list.add(String.valueOf(createprofile));
        }
        if (!StringUtil.isNullOrEmpty(description)) {
            this.list.add(DESCRIPTION);
            this.list.add(description);
        }
        if (!StringUtil.isNullOrEmpty(teams)) {
            this.list.add(TEAMS);
            this.list.add(teams);
        }
        if (!StringUtil.isNullOrEmpty(criticality)) {
            this.list.add(CRITICALITY);
            this.list.add(criticality);
        }
        if (!StringUtil.isNullOrEmpty(sandboxname)) {
            this.list.add(SANDBOXNAME);
            this.list.add(sandboxname);
            this.list.add(CREATESANDBOX);
            this.list.add(String.valueOf(createsandbox));
        }
        if (!StringUtil.isNullOrEmpty(version)) {
            this.list.add(VERSION);
            this.list.add(version);
        }
        boolean canAutoScan = true;
        if (!StringUtil.isNullOrEmpty(include)) {
            this.list.add(INCLUDE);
            this.list.add(include);
            canAutoScan = false;
        }
        if (!StringUtil.isNullOrEmpty(exclude)) {
            this.list.add(EXCLUDE);
            this.list.add(exclude);
            canAutoScan = false;
        }
        if (canAutoScan) {
            this.list.add(AUTOSCAN);
            this.list.add(Boolean.toString(true));
        }
        if (!StringUtil.isNullOrEmpty(pattern) && !StringUtil.isNullOrEmpty(replacement)) {
            this.list.add(PATTERN);
            this.list.add(pattern);
            this.list.add(REPLACEMENT);
            this.list.add(replacement);
        }
        this.list.add(MAXRETRYCOUNT);
        this.list.add(String.valueOf(5));
        if (filepath != null) {
            for (String s : filepath) {
                if (StringUtil.isNullOrEmpty(s)) continue;
                this.list.add(FILEPATH);
                this.list.add(s);
            }
        }
    }

    protected void addUserAgent(String userAgent) {
        if (!StringUtil.isNullOrEmpty(userAgent)) {
            this.list.add("-useragent");
            this.list.add(userAgent);
        }
    }

    private static String createDescriptionArg(FilePath workspaceFilePath) {
        String description_3fs = "Jenkins-URL: %s Host-Name: %s Workspace-Path: %s (Auto-generated by Veracode Jenkins Plugin)";
        String url = null;
        String hostName = null;
        String path = null;
        try {
            String rootUrl = Hudson.getInstance().getRootUrl();
            url = !StringUtil.isNullOrEmpty(rootUrl) ? rootUrl : "Not set in global config.";
        }
        catch (Exception e) {
            url = "Not found.";
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            hostName = "Not found.";
        }
        try {
            path = FileUtil.getStringFilePath(workspaceFilePath);
        }
        catch (Exception e) {
            path = "Not found.";
        }
        return String.format(description_3fs, url, hostName, path);
    }

    public static UploadAndScanArgs newUploadAndScanArgs(VeracodeNotifier notifier, AbstractBuild<?, ?> build, EnvVars envVars, String[] filePaths, boolean bRemoteScan) {
        VeracodeNotifier.VeracodeDescriptor descriptor = notifier.getDescriptor();
        String vId = notifier.getCredentials() == null ? descriptor.getGvid() : notifier.getVid();
        String vKey = notifier.getCredentials() == null ? descriptor.getGvkey() : notifier.getVkey();
        String phost = null;
        String pport = null;
        String puser = null;
        String ppassword = null;
        if (descriptor.getProxy()) {
            phost = descriptor.getPhost();
            pport = descriptor.getPport();
            puser = descriptor.getPuser();
            ppassword = descriptor.getPpassword();
        }
        return UploadAndScanArgs.newUploadAndScanArgs(bRemoteScan, descriptor.getAutoappname(), descriptor.getAutodescription(), descriptor.getAutoversion(), notifier.getCreatesandbox(), notifier.getCreateprofile(), notifier.getTeams(), descriptor.getProxy(), vId, vKey, build.getDisplayName(), build.getProject().getDisplayName(), notifier.getAppname(), notifier.getSandboxname(), notifier.getVersion(), notifier.getCriticality(), notifier.getScanincludespattern(), notifier.getScanexcludespattern(), notifier.getFilenamepattern(), notifier.getReplacementpattern(), phost, pport, puser, ppassword, build.getWorkspace(), envVars, notifier.getTimeout(), filePaths);
    }

    public static UploadAndScanArgs newUploadAndScanArgs(boolean bRemoteScan, boolean autoApplicationName, boolean autoDescription, boolean autoScanName, boolean createSandbox, boolean createProfile, String teams, boolean useProxy, String vId, String vKey, String buildNumber, String projectName, String applicationName, String sandboxName, String scanName, String criticality, String scanIncludesPattern, String scanExcludesPattern, String fileNamePattern, String replacementPattern, String pHost, String pPort, String pUser, String pCredential, FilePath workspace, EnvVars envVars, String timeOut, String[] filePaths) {
        String description = null;
        String phost = null;
        String pport = null;
        String puser = null;
        String ppassword = null;
        if (!StringUtil.isNullOrEmpty(vId)) {
            vId = envVars.expand(vId);
        }
        if (!StringUtil.isNullOrEmpty(vKey)) {
            vKey = envVars.expand(vKey);
        }
        UploadAndScanArgs.setEnvVars(envVars, StringUtil.getEmptyIfNull(buildNumber), StringUtil.getEmptyIfNull(projectName));
        if (!StringUtil.isNullOrEmpty(applicationName)) {
            applicationName = envVars.expand(applicationName);
        } else if (autoApplicationName) {
            applicationName = (String)envVars.get((Object)CUSTOM_PROJECT_NAME_VAR);
        }
        if (!StringUtil.isNullOrEmpty(sandboxName)) {
            sandboxName = envVars.expand(sandboxName);
        }
        if (!StringUtil.isNullOrEmpty(scanName)) {
            scanName = envVars.expand(scanName);
        } else if (autoScanName) {
            scanName = (String)envVars.get((Object)CUSTOM_BUILD_NUMBER_VAR);
        }
        if (!StringUtil.isNullOrEmpty(scanIncludesPattern)) {
            scanIncludesPattern = envVars.expand(scanIncludesPattern);
        }
        if (!StringUtil.isNullOrEmpty(scanExcludesPattern)) {
            scanExcludesPattern = envVars.expand(scanExcludesPattern);
        }
        if (autoDescription) {
            description = UploadAndScanArgs.createDescriptionArg(workspace.getParent());
        }
        if (useProxy) {
            phost = pHost;
            pport = pPort;
            puser = pUser;
            ppassword = pCredential;
        }
        UploadAndScanArgs args = new UploadAndScanArgs();
        args.addApiCredentials(vId, vKey);
        args.addProxyCredentials(puser, ppassword);
        args.addProxyConfiguration(phost, pport);
        args.addStdArguments(bRemoteScan, applicationName, description, createProfile, teams, criticality, sandboxName, createSandbox, scanName, scanIncludesPattern, scanExcludesPattern, fileNamePattern, replacementPattern, timeOut, filePaths);
        args.addUserAgent(UserAgentUtil.getVersionDetails());
        return args;
    }

    public static void setEnvVars(EnvVars envVars, String buildNumber, String projectName) {
        if (null == envVars) {
            return;
        }
        envVars.put(CUSTOM_TIMESTAMP_VAR, new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date()));
        envVars.put(CUSTOM_BUILD_NUMBER_VAR, StringUtil.getEmptyIfNull(buildNumber));
        envVars.put(CUSTOM_PROJECT_NAME_VAR, StringUtil.getEmptyIfNull(projectName));
    }
}

