/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.veracode.args;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import io.jenkins.plugins.veracode.DynamicRescanNotifier;
import io.jenkins.plugins.veracode.VeracodeNotifier;
import io.jenkins.plugins.veracode.args.AbstractArgs;
import io.jenkins.plugins.veracode.utils.StringUtil;
import io.jenkins.plugins.veracode.utils.UserAgentUtil;
import jenkins.model.Jenkins;

public final class DynamicRescanArgs
extends AbstractArgs {
    private static final String APPNAME = "-appname";
    private static final String VERSION = "-version";
    private static final String FLAWONLY = "-flawonly";
    private static final String CUSTOM_PROJECT_NAME_VAR = "projectname";

    private DynamicRescanArgs() {
        this.addAction("CreateAndSubmitDynamicRescan");
    }

    public static DynamicRescanArgs dynamicScanArgs(DynamicRescanNotifier dynamicScanDescriptor, AbstractBuild<?, ?> build, EnvVars environment) {
        VeracodeNotifier.VeracodeDescriptor veracodeDescriptor = (VeracodeNotifier.VeracodeDescriptor)Jenkins.getInstance().getDescriptor(VeracodeNotifier.class);
        DynamicRescanArgs args = new DynamicRescanArgs();
        String vid = null;
        String vkey = null;
        if (veracodeDescriptor != null) {
            vid = veracodeDescriptor.getGvid();
            vkey = veracodeDescriptor.getGvkey();
        }
        String appname = dynamicScanDescriptor.getAppname();
        boolean isDVREnabled = dynamicScanDescriptor.getDvrenabled();
        boolean autoAppName = dynamicScanDescriptor.getDescriptor().getAutoappname();
        boolean autoversion = dynamicScanDescriptor.getDescriptor().getAutoversion();
        String scanName = StringUtil.getEmptyIfNull(build.getDisplayName());
        environment.put(CUSTOM_PROJECT_NAME_VAR, StringUtil.getEmptyIfNull(build.getProject().getDisplayName()));
        if (!StringUtil.isNullOrEmpty(vid)) {
            vid = environment.expand(vid);
        }
        if (!StringUtil.isNullOrEmpty(vkey)) {
            vkey = environment.expand(vkey);
        }
        if (!StringUtil.isNullOrEmpty(appname)) {
            appname = environment.expand(appname);
        }
        if (!StringUtil.isNullOrEmpty(appname)) {
            appname = environment.expand(appname);
        } else if (autoAppName) {
            appname = (String)environment.get((Object)CUSTOM_PROJECT_NAME_VAR);
        }
        args.addApiCredentials(vid, vkey);
        args.addStdArguments(appname, scanName, isDVREnabled, autoversion);
        if (veracodeDescriptor != null) {
            args.setProxy(veracodeDescriptor, args);
        }
        args.addUserAgent(UserAgentUtil.getVersionDetails());
        return args;
    }

    private void addStdArguments(String appname, String version, Boolean isDvr, Boolean autoVersion) {
        if (!StringUtil.isNullOrEmpty(appname)) {
            this.list.add(APPNAME);
            this.list.add(appname);
            if (!StringUtil.isNullOrEmpty(version) && autoVersion.booleanValue()) {
                this.list.add(VERSION);
                this.list.add(version);
            }
            this.list.add(FLAWONLY);
            this.list.add(String.valueOf(isDvr));
        }
    }

    protected void addUserAgent(String userAgent) {
        if (!StringUtil.isNullOrEmpty(userAgent)) {
            this.list.add("-useragent");
            this.list.add(userAgent);
        }
    }

    private void setProxy(VeracodeNotifier.VeracodeDescriptor veracodeDescriptor, DynamicRescanArgs args) {
        String phost = null;
        String pport = null;
        String puser = null;
        String ppassword = null;
        if (veracodeDescriptor.getProxy()) {
            phost = veracodeDescriptor.getPhost();
            pport = veracodeDescriptor.getPport();
            puser = veracodeDescriptor.getPuser();
            ppassword = veracodeDescriptor.getPpassword();
        }
        args.addProxyCredentials(puser, ppassword);
        args.addProxyConfiguration(phost, pport);
    }

    public static DynamicRescanArgs pipelineRescanArgs(boolean autoApplicationName, boolean autoDescription, boolean autoScanName, boolean useProxy, String vId, String vKey, String version, String projectName, String applicationName, boolean DVREnabled, String pHost, String pPort, String pUser, String pCredential, FilePath workspace, EnvVars envVars) {
        String phost = null;
        String pport = null;
        String puser = null;
        String ppassword = null;
        if (!StringUtil.isNullOrEmpty(vId)) {
            vId = envVars.expand(vId);
        }
        if (!StringUtil.isNullOrEmpty(vKey)) {
            vKey = envVars.expand(vKey);
        }
        envVars.put(CUSTOM_PROJECT_NAME_VAR, StringUtil.getEmptyIfNull(projectName));
        if (!StringUtil.isNullOrEmpty(applicationName)) {
            applicationName = envVars.expand(applicationName);
        } else if (autoApplicationName) {
            applicationName = (String)envVars.get((Object)CUSTOM_PROJECT_NAME_VAR);
        }
        if (useProxy) {
            phost = pHost;
            pport = pPort;
            puser = pUser;
            ppassword = pCredential;
        }
        DynamicRescanArgs args = new DynamicRescanArgs();
        args.addApiCredentials(vId, vKey);
        args.addProxyCredentials(puser, ppassword);
        args.addProxyConfiguration(phost, pport);
        args.addStdArguments(applicationName, version, DVREnabled, autoScanName);
        args.addUserAgent(UserAgentUtil.getVersionDetails());
        return args;
    }
}

