/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.veracode.args;

import io.jenkins.plugins.veracode.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractArgs {
    private static final byte MASKED_ARG_LENGTH = 8;
    protected static final String SWITCH = "-";
    protected static final String ACTION = "-action";
    protected static final String PHOST = "-phost";
    protected static final String PPASSWORD = "-ppassword";
    protected static final String PPORT = "-pport";
    protected static final String PUSER = "-puser";
    protected static final String VID = "-vid";
    protected static final String VKEY = "-vkey";
    protected static final String USERAGENT = "-useragent";
    protected final List<String> list = new ArrayList<String>();

    protected AbstractArgs() {
    }

    protected void addProxyConfiguration(String phost, String pport) {
        if (!StringUtil.isNullOrEmpty(phost)) {
            this.list.add(PHOST);
            this.list.add(phost);
        }
        if (!StringUtil.isNullOrEmpty(pport)) {
            this.list.add(PPORT);
            this.list.add(pport);
        }
    }

    protected void addProxyCredentials(String puser, String ppassword) {
        if (!StringUtil.isNullOrEmpty(puser)) {
            this.list.add(PUSER);
            this.list.add(puser);
        }
        if (!StringUtil.isNullOrEmpty(ppassword)) {
            this.list.add(PPASSWORD);
            this.list.add(ppassword);
        }
    }

    protected void addApiCredentials(String vid, String vkey) {
        if (!StringUtil.isNullOrEmpty(vid)) {
            this.list.add(VID);
            this.list.add(vid);
        }
        if (!StringUtil.isNullOrEmpty(vkey)) {
            this.list.add(VKEY);
            this.list.add(vkey);
        }
    }

    protected void addAction(String action) {
        if (!StringUtil.isNullOrEmpty(action)) {
            this.list.add(ACTION);
            this.list.add(action);
        }
    }

    public String[] getArguments() {
        return this.list.toArray(new String[0]);
    }

    public String[] getMaskedArguments() {
        String[] args = this.getArguments();
        for (int x = 0; x < args.length; ++x) {
            if (!VKEY.equals(args[x]) && !PPASSWORD.equals(args[x]) || x % 2 != 0 || x >= args.length - 1 || args[x + 1] == null) continue;
            args[x + 1] = StringUtil.repeatChar('*', args[x + 1].length() > 0 ? 8 : 0);
        }
        return args;
    }
}

