/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.veracode;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import io.jenkins.plugins.veracode.common.DAAdapterService;
import io.jenkins.plugins.veracode.data.ProxyBlock;
import io.jenkins.plugins.veracode.utils.FormValidationUtil;
import io.jenkins.plugins.veracode.utils.StringUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class DynamicAnalysisStartPipelineRecorder
extends Recorder
implements SimpleBuildStep {
    @DataBoundSetter
    public final String analysisName;
    @DataBoundSetter
    public final int maximumDuration;
    @DataBoundSetter
    public final boolean failBuildAsScanFailed;
    @DataBoundSetter
    public final String vid;
    @DataBoundSetter
    public final String vkey;
    @DataBoundSetter
    public final boolean debug;
    @DataBoundSetter
    public final boolean useProxy;
    @DataBoundSetter
    public final String pHost;
    @DataBoundSetter
    public final String pPort;
    @DataBoundSetter
    public final String pUser;
    @DataBoundSetter
    public final String pPassword;

    @DataBoundConstructor
    public DynamicAnalysisStartPipelineRecorder(String analysisName, int maximumDuration, boolean failBuildAsScanFailed, String vid, String vkey, boolean debug, boolean useProxy, String pHost, String pPort, String pUser, String pPassword) {
        this.analysisName = analysisName;
        this.maximumDuration = maximumDuration;
        this.failBuildAsScanFailed = failBuildAsScanFailed;
        this.vid = vid;
        this.vkey = vkey;
        this.debug = debug;
        this.useProxy = useProxy;
        this.pHost = useProxy ? pHost : null;
        this.pPort = useProxy ? pPort : null;
        this.pUser = useProxy ? pUser : null;
        this.pPassword = useProxy ? pPassword : null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return null;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        DAAdapterService daAdapterService;
        boolean buildSuccess;
        ProxyBlock proxyBlock = null;
        if (this.useProxy) {
            proxyBlock = new ProxyBlock(this.pHost, this.pPort, this.pUser, this.pPassword);
        }
        run.setResult((buildSuccess = (daAdapterService = new DAAdapterService()).resubmitDynamicAnalysis(run, workspace, listener, this.analysisName, this.maximumDuration, this.failBuildAsScanFailed, this.vid, this.vkey, this.debug, proxyBlock)) ? Result.SUCCESS : Result.FAILURE);
    }

    public DynamicAnalysisStartPipelineDescriptor getDescriptor() {
        return (DynamicAnalysisStartPipelineDescriptor)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"veracodeDynamicAnalysisResubmit"})
    public static class DynamicAnalysisStartPipelineDescriptor
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return false;
        }

        public String getDisplayName() {
            return "Resubmit Veracode Dynamic Analysis";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String maximumDuration = formData.getString("maximumDuration");
            formData.put("maximumDuration", StringUtil.isNullOrEmpty(maximumDuration) ? Integer.valueOf(72) : maximumDuration);
            return (Publisher)super.newInstance(req, formData);
        }

        public FormValidation doCheckAnalysisName(@QueryParameter String analysisName) throws IOException, ServletException {
            return FormValidationUtil.checkAnalysisName(analysisName);
        }

        public FormValidation doCheckMaximumDuration(@QueryParameter String maximumDuration) throws IOException, ServletException {
            return FormValidationUtil.checkMaximumDuration(maximumDuration);
        }

        public FormValidation doCheckPHost(@QueryParameter(value="pHost") String pHost, @QueryParameter(value="pPort") String pPort) throws IOException, ServletException {
            return FormValidationUtil.checkFields(pHost, pPort, "Host", "Port", null);
        }

        public FormValidation doCheckPPort(@QueryParameter(value="pHost") String pHost, @QueryParameter(value="pPort") String pPort) throws IOException, ServletException {
            return FormValidationUtil.checkFields(pPort, pHost, "Port", "Host", null);
        }

        public FormValidation doCheckPUser(@QueryParameter(value="pUser") String pUser, @QueryParameter(value="pPassword") String pPassword) throws IOException, ServletException {
            return FormValidationUtil.checkMutuallyInclusiveFields(pUser, pPassword, "User", "Password", null);
        }

        public FormValidation doCheckPPassword(@QueryParameter(value="pUser") String pUser, @QueryParameter(value="pPassword") String pPassword) throws IOException, ServletException {
            return FormValidationUtil.checkMutuallyInclusiveFields(pPassword, pUser, "Password", "User", null);
        }
    }
}

