/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import hudson.util.FormValidation;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;

public abstract class ValidationUtils {
    private static StringBuilder builder;
    private static String normalizeSpace;
    private static List<String> params;

    public static JSONObject buildParameter(String domain, Boolean externalEmail, JSONObject jsonObject) {
        builder = new StringBuilder();
        normalizeSpace = jsonObject.getString(Key.VALUE.getValue()).trim();
        params = Arrays.asList(normalizeSpace.split(" "));
        String domainRegEx = "^[A-Za-z0-9._%+-]+@{DOMAIN_NAME}".replace("{DOMAIN_NAME}", domain);
        if (!params.isEmpty()) {
            for (String s : params) {
                if (Pattern.matches("^([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\\.([a-zA-Z]{2,5})$", s)) {
                    if (!externalEmail.booleanValue()) {
                        if (Pattern.matches(domainRegEx, s) && Pattern.matches("^([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\\.([a-zA-Z]{2,5})$", s)) {
                            builder.append(s).append(" ");
                            continue;
                        }
                        jsonObject.put(Key.IS_VALID.getValue(), (Object)false);
                        jsonObject.put(Key.ERROR.getValue(), (Object)("Invalid email for parameter [" + jsonObject.getString("name") + "] expected domain : @" + domain + " specified: " + s));
                        return jsonObject;
                    }
                    builder.append(s).append(" ");
                    continue;
                }
                if (!s.isEmpty()) {
                    if (!externalEmail.booleanValue()) {
                        if (Pattern.matches(domainRegEx, s + "@" + domain)) {
                            builder.append(s).append("@").append(domain).append(" ");
                            continue;
                        }
                        jsonObject.put(Key.IS_VALID.getValue(), (Object)false);
                        jsonObject.put(Key.ERROR.getValue(), (Object)("Invalid email for parameter [" + jsonObject.getString("name") + "] expected domain : @" + domain + " specified: " + s));
                        return jsonObject;
                    }
                    if (Pattern.matches("^([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\\.([a-zA-Z]{2,5})$", s + "@" + domain)) {
                        builder.append(s).append("@").append(domain).append(" ");
                        continue;
                    }
                    jsonObject.put(Key.IS_VALID.getValue(), (Object)false);
                    jsonObject.put(Key.ERROR.getValue(), (Object)("Invalid email for parameter [" + jsonObject.getString("name") + "] Value entered does not match email pattern; specified: " + s));
                    return jsonObject;
                }
                if (s.isEmpty()) {
                    jsonObject.put(Key.IS_VALID.getValue(), (Object)false);
                    jsonObject.put(Key.ERROR.getValue(), (Object)("Invalid email for parameter [ " + jsonObject.getString("name") + " ] Expected domain : @" + domain + " Specified: [ Email is Empty! ]"));
                    return jsonObject;
                }
                jsonObject.put(Key.IS_VALID.getValue(), (Object)false);
                jsonObject.put(Key.ERROR.getValue(), (Object)("Value entered does not match email pattern; Expected domain : @" + domain + " Specified: " + s));
                return jsonObject;
            }
            jsonObject.replace((Object)Key.VALUE.getValue(), (Object)String.valueOf(builder).trim());
            jsonObject.put(Key.IS_VALID.getValue(), (Object)true);
            return jsonObject;
        }
        jsonObject.put(Key.IS_VALID.getValue(), (Object)true);
        return jsonObject;
    }

    public static String definitionParameter(String defaultValue, String domain) {
        builder = new StringBuilder();
        normalizeSpace = defaultValue.trim();
        params = Arrays.asList(normalizeSpace.split(" "));
        if (!params.isEmpty()) {
            for (String value : params) {
                if (Pattern.matches("^([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\\.([a-zA-Z]{2,5})$", value)) {
                    builder.append(value).append(" ");
                    continue;
                }
                if (!value.isEmpty()) {
                    builder.append(value).append("@").append(domain).append(" ");
                    continue;
                }
                return defaultValue;
            }
            return String.valueOf(builder).trim();
        }
        return defaultValue;
    }

    public static FormValidation formParameter(String domain, String value, Boolean externalEmail) {
        builder = new StringBuilder();
        normalizeSpace = value.trim();
        params = Arrays.asList(normalizeSpace.split(" "));
        String domainRegEx = "^[A-Za-z0-9._%+-]+@{DOMAIN_NAME}".replace("{DOMAIN_NAME}", domain);
        if (!params.isEmpty()) {
            for (String s : params) {
                if (Pattern.matches("^([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\\.([a-zA-Z]{2,5})$", s)) {
                    if (!externalEmail.booleanValue()) {
                        if (Pattern.matches(domainRegEx, s) && Pattern.matches("^([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\\.([a-zA-Z]{2,5})$", s)) {
                            builder.append(s).append(" ");
                            continue;
                        }
                        return FormValidation.error((String)("Value entered does not match domain : " + s));
                    }
                    builder.append(s).append(" ");
                    continue;
                }
                if (!s.isEmpty()) {
                    if (!externalEmail.booleanValue()) {
                        if (Pattern.matches(domainRegEx, s + "@" + domain)) {
                            builder.append(s).append("@").append(domain).append(" ");
                            continue;
                        }
                        return FormValidation.error((String)("Value entered does not match domain : " + s));
                    }
                    if (Pattern.matches("^([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\\.([a-zA-Z]{2,5})$", s + "@" + domain)) {
                        builder.append(s).append("@").append(domain).append(" ");
                        continue;
                    }
                    return FormValidation.error((String)("Value entered does not match email address pattern : " + s));
                }
                if (s.isEmpty()) {
                    return FormValidation.warning((String)"Email address is empty.");
                }
                return FormValidation.error((String)("Value entered does not match email pattern : " + s));
            }
            return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)("<div class='ok' style='color:green;'><span>&#9989;</span><b> Valid Email : </b>" + builder + "</div>"));
        }
        return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)("<div class='ok' style='color:green;'><span>&#9989;</span><b> Valid Email : </b>" + value + "</div>"));
    }

    public static enum Key {
        ERROR("error"),
        VALUE("value"),
        IS_VALID("is_valid");

        private final String value;

        private Key(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

