/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_oauth.helper;

import com.google.inject.Inject;
import io.jenkins.plugins.tuleap_oauth.helper.PluginHelper;
import io.jenkins.plugins.tuleap_oauth.helper.TuleapAuthorizationCodeUrlBuilder;
import io.jenkins.plugins.tuleap_oauth.pkce.PKCECodeBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;

public class TuleapAuthorizationCodeUrlBuilderImpl
implements TuleapAuthorizationCodeUrlBuilder {
    private static final Logger LOGGER = Logger.getLogger(TuleapAuthorizationCodeUrlBuilder.class.getName());
    private final PluginHelper pluginHelper;
    private final PKCECodeBuilder codeBuilder;

    @Inject
    public TuleapAuthorizationCodeUrlBuilderImpl(PluginHelper pluginHelper, PKCECodeBuilder codeBuilder) {
        this.pluginHelper = pluginHelper;
        this.codeBuilder = codeBuilder;
    }

    @Override
    public String buildRedirectUrlAndStoreSessionAttribute(StaplerRequest request, String tuleapUri, String clientId) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        if (!this.pluginHelper.isHttpsUrl(tuleapUri)) {
            LOGGER.warning("The provided Tuleap URL is not in HTTPS");
            return this.pluginHelper.getJenkinsInstance().getRootUrl() + "tuleapError";
        }
        String state = this.pluginHelper.buildRandomBase64EncodedURLSafeString();
        request.getSession().setAttribute("state", (Object)state);
        String rootUrl = this.pluginHelper.getJenkinsInstance().getRootUrl();
        String redirectUri = URLEncoder.encode(rootUrl + "securityRealm/finishLogin", StandardCharsets.UTF_8.name());
        String codeVerifier = this.codeBuilder.buildCodeVerifier();
        String codeChallenge = this.codeBuilder.buildCodeChallenge(codeVerifier);
        request.getSession().setAttribute("code_verifier", (Object)codeVerifier);
        String nonce = this.pluginHelper.buildRandomBase64EncodedURLSafeString();
        request.getSession().setAttribute("nonce", (Object)nonce);
        request.getSession().setAttribute("redirect_uri", (Object)(this.pluginHelper.getJenkinsInstance().getRootUrl() + "securityRealm/finishLogin"));
        return tuleapUri + "oauth2/authorize?response_type=code&client_id=" + URLEncoder.encode(clientId, StandardCharsets.UTF_8.name()) + "&redirect_uri=" + redirectUri + "&scope=" + URLEncoder.encode("read:project read:user_membership openid profile email", StandardCharsets.UTF_8.name()) + "&state=" + state + "&code_challenge=" + codeChallenge + "&code_challenge_method=" + URLEncoder.encode("S256", StandardCharsets.UTF_8.name()) + "&nonce=" + nonce;
    }
}

