/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_oauth.checks;

import com.google.inject.Inject;
import io.jenkins.plugins.tuleap_oauth.checks.AuthorizationCodeChecker;
import io.jenkins.plugins.tuleap_oauth.helper.PluginHelper;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;

public class AuthorizationCodeCheckerImpl
implements AuthorizationCodeChecker {
    private static final Logger LOGGER = Logger.getLogger(AuthorizationCodeCheckerImpl.class.getName());
    private final PluginHelper pluginHelper;

    @Inject
    public AuthorizationCodeCheckerImpl(PluginHelper pluginHelper) {
        this.pluginHelper = pluginHelper;
    }

    @Override
    public boolean checkAuthorizationCode(StaplerRequest request) {
        String expectedRedirectURI = (String)request.getSession().getAttribute("redirect_uri");
        if (StringUtils.isBlank((String)expectedRedirectURI)) {
            LOGGER.log(Level.WARNING, "no redirect saved from user's session");
            return false;
        }
        if (!expectedRedirectURI.equals(this.pluginHelper.getJenkinsInstance().getRootUrl() + "securityRealm/finishLogin")) {
            LOGGER.log(Level.WARNING, "the expected URI changed during redirection");
            return false;
        }
        String code = request.getParameter("code");
        if (StringUtils.isBlank((String)code)) {
            LOGGER.log(Level.WARNING, "no code returned");
            return false;
        }
        String state = request.getParameter("state");
        String expectedState = (String)request.getSession().getAttribute("state");
        if (StringUtils.isBlank((String)state)) {
            LOGGER.log(Level.WARNING, "no state returned");
            return false;
        }
        if (StringUtils.isBlank((String)expectedState)) {
            LOGGER.log(Level.WARNING, "no state saved from user's session");
            return false;
        }
        if (!MessageDigest.isEqual(state.getBytes(StandardCharsets.UTF_8), expectedState.getBytes(StandardCharsets.UTF_8))) {
            LOGGER.log(Level.WARNING, "expected state and provided state does not match");
            return false;
        }
        String codeVerifier = (String)request.getSession().getAttribute("code_verifier");
        if (StringUtils.isBlank((String)codeVerifier)) {
            LOGGER.log(Level.WARNING, "no code verifier saved from user's session");
            return false;
        }
        return true;
    }
}

