/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_oauth;

import java.util.ArrayList;
import java.util.stream.Stream;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.UserDetails;

public class TuleapUserDetails
implements UserDetails {
    private final String username;
    private final ArrayList<GrantedAuthority> authorities;
    private final ArrayList<GrantedAuthority> tuleapAuthorities;

    public TuleapUserDetails(String username) {
        this.username = username;
        this.authorities = new ArrayList();
        this.tuleapAuthorities = new ArrayList();
    }

    public GrantedAuthority[] getAuthorities() {
        return (GrantedAuthority[])Stream.concat(this.authorities.stream(), this.tuleapAuthorities.stream()).toArray(GrantedAuthority[]::new);
    }

    public void addAuthority(GrantedAuthority authority) {
        this.authorities.add(authority);
    }

    public void addTuleapAuthority(GrantedAuthority tuleapAuthority) {
        this.tuleapAuthorities.add(tuleapAuthority);
    }

    public String getPassword() {
        return "";
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean equals(Object rhs) {
        return super.equals(rhs);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

