/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tics;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import hudson.plugins.tics.HtmlTag;
import hudson.plugins.tics.MeasureApiCall;
import hudson.plugins.tics.MeasureApiSuccessResponse;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;

public class TqiPublisherResultBuilder {
    public static final String METRICS_3_11 = "tqi,tqiTestCoverage,tqiAbstrInt,tqiComplexity,tqiCompWarn,tqiCodingStd,tqiDupCode,tqiFanOut,tqiDeadCode,loc";
    public static final String METRICS_4_0 = "tqi,tqiTestCoverage,tqiAbstrInt,tqiComplexity,tqiCompWarn,tqiCodingStd,tqiDupCode,tqiFanOut,tqiSecurity,loc";
    public static final String TQI_VERSION = "tqiVersion";
    private final PrintStream logger;
    private final DecimalFormat percentageFormatter;
    private final NumberFormat integerFormatter;
    private final String ticsPath;
    private final MeasureApiCall measureApiCall;
    private final Supplier<Optional<List<MeasureApiSuccessResponse.Run>>> runDates = Suppliers.memoize((Supplier)new Supplier<Optional<List<MeasureApiSuccessResponse.Run>>>(){

        public Optional<List<MeasureApiSuccessResponse.Run>> get() {
            MeasureApiSuccessResponse<List<MeasureApiSuccessResponse.Run>> resp;
            try {
                resp = TqiPublisherResultBuilder.this.measureApiCall.execute(MeasureApiCall.RESPONSE_RUNS_TYPETOKEN, TqiPublisherResultBuilder.this.ticsPath, "runs", Optional.empty());
            }
            catch (MeasureApiCall.MeasureApiCallException e) {
                e.printStackTrace(TqiPublisherResultBuilder.this.logger);
                return Optional.empty();
            }
            if (resp.data.isEmpty()) {
                return Optional.empty();
            }
            MeasureApiSuccessResponse.MetricValue mv = resp.data.get(0);
            return Optional.of(mv.value);
        }
    });
    private final Supplier<Optional<MeasureApiSuccessResponse.Baseline>> baseline = Suppliers.memoize((Supplier)new Supplier<Optional<MeasureApiSuccessResponse.Baseline>>(){

        public Optional<MeasureApiSuccessResponse.Baseline> get() {
            MeasureApiSuccessResponse<List<MeasureApiSuccessResponse.Baseline>> resp;
            try {
                resp = TqiPublisherResultBuilder.this.measureApiCall.execute(MeasureApiCall.RESPONSE_BASELINES_TYPETOKEN, TqiPublisherResultBuilder.this.ticsPath, "baselines", Optional.empty());
            }
            catch (MeasureApiCall.MeasureApiCallException e) {
                e.printStackTrace(TqiPublisherResultBuilder.this.logger);
                return Optional.empty();
            }
            if (resp.data.isEmpty()) {
                return Optional.empty();
            }
            MeasureApiSuccessResponse.MetricValue mv = resp.data.get(0);
            List baselines = (List)mv.value;
            if (baselines.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(baselines.get(baselines.size() - 1));
        }
    });

    public TqiPublisherResultBuilder(PrintStream logger, Optional<StandardUsernamePasswordCredentials> credentials, String measureApiUrl, String ticsPath) {
        this.logger = logger;
        this.ticsPath = ticsPath;
        this.percentageFormatter = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        this.percentageFormatter.setMaximumFractionDigits(2);
        this.percentageFormatter.setMinimumFractionDigits(2);
        this.percentageFormatter.setRoundingMode(RoundingMode.FLOOR);
        this.integerFormatter = NumberFormat.getInstance(Locale.US);
        this.measureApiCall = new MeasureApiCall(logger, measureApiUrl, credentials);
    }

    public TqiPublisherResult run() {
        String tableHtml;
        try {
            tableHtml = this.createTableHtml();
        }
        catch (Exception ex) {
            ex.printStackTrace(this.logger);
            String msg = ex.getMessage();
            String tableHtml2 = "<div>An error occurred while retrieving metrics: <blockquote>" + msg + "</blockquote>Consult the console output for more information.</div>";
            throw new RuntimeException("Could not publish the TICS results.", ex);
        }
        return new TqiPublisherResult(tableHtml, this.ticsPath);
    }

    private String createTableHtml() throws MeasureApiCall.MeasureApiCallException {
        boolean hasSecurity = this.doesTqiVersionIncludeSecurity();
        String metrics = hasSecurity ? METRICS_4_0 : METRICS_3_11;
        MeasureApiSuccessResponse<Double> mvsCurrent = this.measureApiCall.execute(MeasureApiCall.RESPONSE_DOUBLE_TYPETOKEN, this.ticsPath, metrics);
        Optional mvsPrevious = this.getPreviousRunDate().isPresent() ? this.tryQueryMetricsForDate(this.getPreviousRunDate().get(), metrics) : Optional.empty();
        Optional mvsBaseline = ((Optional)this.baseline.get()).isPresent() ? this.tryQueryMetricsForDate(((MeasureApiSuccessResponse.Baseline)((Optional)this.baseline.get()).get()).getStarted(), metrics) : Optional.empty();
        StringBuilder sb = new StringBuilder();
        HtmlTag table = HtmlTag.from("table").attr("style", "border-spacing: 0px").attr("style", "border: 1px solid #CCC");
        sb.append(table.open());
        sb.append("<thead>");
        sb.append("<tr>");
        sb.append(HtmlTag.from("th").attr("style", "text-align: left").openClose("Metric"));
        HtmlTag th = HtmlTag.from("th").attr("style", "text-align: right").attr("style", "width: 80px");
        th = th.attr("style", "cursor: help");
        sb.append(th.attr("title", "Last TICS run was at\n" + this.getLastRunDate().orElse(Instant.now()).toDateTime().toString(DateTimeFormat.longDateTime())).openClose("Current"));
        sb.append("<th style=\"width: 26px\"><!-- Letter --></th>");
        if (mvsPrevious.isPresent()) {
            String title = "Delta with previous TICS run at\n" + this.getPreviousRunDate().orElse(Instant.now()).toDateTime().toString(DateTimeFormat.longDateTime());
            sb.append(th.attr("title", title).openClose("&Delta;Previous"));
        }
        if (mvsBaseline.isPresent() && ((Optional)this.baseline.get()).isPresent()) {
            MeasureApiSuccessResponse.Baseline bl = (MeasureApiSuccessResponse.Baseline)((Optional)this.baseline.get()).get();
            String title = "Delta with baseline '" + bl.getName() + "' at\n" + bl.getStarted().toDateTime().toString(DateTimeFormat.longDateTime());
            sb.append(th.attr("title", title).open());
            HtmlTag div = HtmlTag.from("div").attr("style", "overflow: hidden").attr("style", "text-overflow: clip").attr("style", "white-space: nowrap").attr("style", "width: 80px");
            sb.append(div.open());
            sb.append("&Delta;" + bl.getName());
            sb.append(div.close());
        }
        sb.append("</tr>");
        sb.append("</thead>");
        sb.append("<tbody>");
        MeasureApiSuccessResponse.MetricValue EMPTY_METRICVALUE = new MeasureApiSuccessResponse.MetricValue();
        for (int i = 0; i < mvsCurrent.data.size(); ++i) {
            MeasureApiSuccessResponse.Metric metric = mvsCurrent.metrics.get(i);
            MeasureApiSuccessResponse.MetricValue mvNow = (MeasureApiSuccessResponse.MetricValue)Iterables.get(mvsCurrent.data, (int)i, EMPTY_METRICVALUE);
            HtmlTag tr = HtmlTag.from("tr");
            sb.append(tr.open());
            HtmlTag td = HtmlTag.from("td").attr("style", "padding-top: 2px; padding-bottom: 2px;").attr("style", "background-color: " + (i % 2 == 0 ? "#EEE" : "#FFF"));
            sb.append(td.open());
            sb.append(metric.fullName);
            sb.append(td.close());
            td = td.attr("style", "text-align: right");
            sb.append(td.open());
            if (mvNow.value == null) {
                sb.append("-");
            } else if (this.isPercentageMetric(metric)) {
                sb.append(this.percentageFormatter.format(mvNow.value));
                sb.append("%");
            } else {
                sb.append(this.integerFormatter.format(mvNow.value));
            }
            sb.append(td.close());
            sb.append(td.open());
            sb.append(this.getLetterToBadge(mvNow.letter));
            sb.append(td.close());
            if (mvsPrevious.isPresent()) {
                this.outputDeltaCell(sb, td, metric, (Double)mvNow.value, (Double)((MeasureApiSuccessResponse.MetricValue)Iterables.get(((MeasureApiSuccessResponse)mvsPrevious.get()).data, (int)i, EMPTY_METRICVALUE)).value);
            }
            if (mvsBaseline.isPresent()) {
                this.outputDeltaCell(sb, td, metric, (Double)mvNow.value, (Double)((MeasureApiSuccessResponse.MetricValue)Iterables.get(((MeasureApiSuccessResponse)mvsBaseline.get()).data, (int)i, EMPTY_METRICVALUE)).value);
            }
            sb.append(tr.close());
        }
        sb.append("</tbody>");
        sb.append("</table>");
        return sb.toString();
    }

    private boolean doesTqiVersionIncludeSecurity() {
        MeasureApiSuccessResponse<MeasureApiSuccessResponse.TqiVersion> resp;
        try {
            resp = this.measureApiCall.execute(MeasureApiCall.RESPONSE_TQIVERSION_TYPETOKEN, this.ticsPath, TQI_VERSION);
        }
        catch (MeasureApiCall.MeasureApiCallException e) {
            e.printStackTrace(this.logger);
            return false;
        }
        if (resp.data.isEmpty() || resp.data.get((int)0).value == null) {
            return false;
        }
        MeasureApiSuccessResponse.TqiVersion tqiVersion = (MeasureApiSuccessResponse.TqiVersion)resp.data.get((int)0).value;
        return tqiVersion.compareTo(new MeasureApiSuccessResponse.TqiVersion(4, 0)) >= 0;
    }

    private String getLetterToBadge(String letter) {
        if (Strings.isNullOrEmpty((String)letter)) {
            return "";
        }
        ImmutableMap tqiBgColors = ImmutableMap.builder().put((Object)"A", (Object)"#006400").put((Object)"B", (Object)"#64AE00").put((Object)"C", (Object)"#FFFF00").put((Object)"D", (Object)"#FF950E").put((Object)"E", (Object)"#FF420E").put((Object)"F", (Object)"#BE0000").build();
        ImmutableMap tqiFgColors = ImmutableMap.builder().put((Object)"A", (Object)"white").put((Object)"B", (Object)"white").put((Object)"C", (Object)"black").put((Object)"D", (Object)"black").put((Object)"E", (Object)"white").put((Object)"F", (Object)"white").build();
        String bgColor = (String)tqiBgColors.get((Object)letter);
        String fgColor = (String)tqiFgColors.get((Object)letter);
        if (bgColor == null || fgColor == null) {
            return "";
        }
        return HtmlTag.from("span").attr("style", "color: " + fgColor).attr("style", "background-color: " + bgColor).attr("style", "padding: 0 7px 0 7px").attr("style", "border-radius: 5px").attr("style", "font-weight: bold").attr("style", "text-align: center").attr("style", "box-shadow: 0px 0px 3px #888888").openClose(letter);
    }

    private void outputDeltaCell(StringBuilder sb, HtmlTag td0, MeasureApiSuccessResponse.Metric metric, Double now, Double prev) {
        String deltaAsText;
        BigDecimal delta;
        if (now == null || prev == null) {
            sb.append("-");
            return;
        }
        if (this.isPercentageMetric(metric)) {
            double diff = now - prev;
            delta = new BigDecimal(diff).setScale(2, RoundingMode.UP);
            deltaAsText = delta.toPlainString();
        } else {
            int diff = now.intValue() - prev.intValue();
            delta = new BigDecimal(diff).setScale(0);
            deltaAsText = this.integerFormatter.format(diff);
        }
        HtmlTag td = td0.attr("style", "text-align: right");
        if (metric.getExpression().startsWith("tqi") && delta.signum() != 0) {
            td = td.attr("style", "color: " + (delta.signum() > 0 ? "green" : "red"));
        }
        sb.append(td.open());
        if (delta.signum() > 0) {
            sb.append("+");
        }
        if (delta.signum() == 0) {
            sb.append("<span style=\"color: #BBB\">0.00</span>");
        } else {
            sb.append(deltaAsText);
        }
        sb.append(td.close());
    }

    private boolean isPercentageMetric(MeasureApiSuccessResponse.Metric metric) {
        boolean isPercentageMetric = metric.getExpression().startsWith("tqi");
        return isPercentageMetric;
    }

    private Optional<MeasureApiSuccessResponse<Double>> tryQueryMetricsForDate(Instant date, String metrics) {
        try {
            return Optional.of(this.measureApiCall.execute(MeasureApiCall.RESPONSE_DOUBLE_TYPETOKEN, this.ticsPath, metrics, Optional.of(date)));
        }
        catch (MeasureApiCall.MeasureApiCallException e) {
            e.printStackTrace(this.logger);
            return Optional.empty();
        }
    }

    private final Optional<Instant> getLastRunDate() {
        List runs = (List)((Optional)this.runDates.get()).orElse(ImmutableList.of());
        if (runs.isEmpty()) {
            return Optional.empty();
        }
        MeasureApiSuccessResponse.Run run = (MeasureApiSuccessResponse.Run)runs.get(runs.size() - 1);
        return Optional.of(run.getStarted());
    }

    private final Optional<Instant> getPreviousRunDate() {
        List runs = (List)((Optional)this.runDates.get()).orElse(ImmutableList.of());
        if (runs.size() <= 1) {
            return Optional.empty();
        }
        MeasureApiSuccessResponse.Run run = (MeasureApiSuccessResponse.Run)runs.get(runs.size() - 2);
        return Optional.of(run.getStarted());
    }

    public static class TqiPublisherResult {
        public String tableHtml;
        public String ticsPath;
        public String measurementDate = Instant.now().toString();

        public TqiPublisherResult(String html, String ticsPath) {
            this.tableHtml = html;
            this.ticsPath = ticsPath;
        }
    }
}

