/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tics;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.ProminentProjectAction;
import hudson.model.Run;
import hudson.plugins.tics.AbstractTicsPublisherAction;
import hudson.plugins.tics.TicsPublisher;
import hudson.plugins.tics.TicsPublisherProjectAction;
import hudson.plugins.tics.TicsQualityGate;
import hudson.plugins.tics.TqiPublisherResultBuilder;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jenkins.tasks.SimpleBuildStep;
import org.apache.http.client.utils.URIBuilder;
import org.joda.time.Instant;

public class TicsPublisherBuildAction
extends AbstractTicsPublisherAction
implements ProminentProjectAction,
SimpleBuildStep.LastBuildAction {
    private final Run<?, ?> run;
    public final String tableHtml;
    public final String ticsPath;
    public final String measurementDate;
    public final String qualityGateTableHtml;
    public final String qualityGateViewerUrl;
    private final String tiobeWebBaseUrl;
    private final List<TicsPublisherProjectAction> projectActions;

    public TicsPublisherBuildAction(Run<?, ?> run, TqiPublisherResultBuilder.TqiPublisherResult tqiPublisherResult, TicsQualityGate.QualityGateResult qualityGateResult, String tiobeWebBaseUrl) {
        this.run = run;
        this.tableHtml = tqiPublisherResult != null ? tqiPublisherResult.tableHtml : null;
        this.ticsPath = tqiPublisherResult != null ? tqiPublisherResult.ticsPath : null;
        this.measurementDate = tqiPublisherResult != null ? tqiPublisherResult.measurementDate : null;
        this.qualityGateTableHtml = qualityGateResult != null ? qualityGateResult.tableHtml : null;
        this.qualityGateViewerUrl = qualityGateResult != null ? qualityGateResult.viewerGateUrl : null;
        ArrayList<TicsPublisherProjectAction> actions = new ArrayList<TicsPublisherProjectAction>();
        actions.add(new TicsPublisherProjectAction(run));
        this.projectActions = actions;
        this.tiobeWebBaseUrl = tiobeWebBaseUrl;
    }

    public String getIconFileName() {
        return null;
    }

    public String getMeasurementDate() {
        if (Strings.isNullOrEmpty((String)this.measurementDate)) {
            return "?";
        }
        return new Instant((Object)this.measurementDate).toDateTime().toString("yyyy-MM-dd HH:mm");
    }

    public static <T extends Publisher> T getPublisher(Run<?, ?> run, Class<T> type) {
        if (run.getParent() instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)run.getParent();
            DescribableList publishersList = project.getPublishersList();
            for (Publisher publisher : publishersList) {
                if (!type.isInstance(publisher)) continue;
                return (T)((Publisher)type.cast(publisher));
            }
        }
        return null;
    }

    public final String getViewerQualityGateDetails() {
        if (this.qualityGateViewerUrl == null) {
            return "";
        }
        String escapedQualityGateViewerUrl = "/" + this.qualityGateViewerUrl.replace("(", "%28").replace(")", "%29");
        return this.openInViewerUrl(escapedQualityGateViewerUrl, "");
    }

    public final String getOpenInViewerUrl() {
        String dashboardFilePath = "/TqiDashboard.html";
        String fragment = "axes=" + this.ticsPath;
        return this.openInViewerUrl("/TqiDashboard.html", fragment);
    }

    public final String openInViewerUrl(String link, String fragment) {
        URI uri;
        String baseUrl;
        if (this.run == null) {
            return "";
        }
        TicsPublisher publisher = TicsPublisherBuildAction.getPublisher(this.run, TicsPublisher.class);
        if (publisher == null) {
            baseUrl = this.tiobeWebBaseUrl;
        } else {
            try {
                baseUrl = publisher.getResolvedTiobewebBaseUrl();
            }
            catch (TicsPublisher.InvalidTicsViewerUrl e) {
                baseUrl = this.tiobeWebBaseUrl;
            }
        }
        try {
            uri = new URIBuilder(baseUrl + link).setFragment(fragment).build();
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return uri.toString();
    }

    public Collection<? extends Action> getProjectActions() {
        return this.projectActions;
    }
}

