/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tics;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.tics.Metrics;
import hudson.plugins.tics.TicsAnalyzer;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class TicsPipelineRun
extends Builder
implements SimpleBuildStep {
    private static final ImmutableSet<String> ALL_METRICS = ImmutableSet.of((Object)"ABSTRACTINTERPRETATION", (Object)"ACCUCHANGERATE", (Object)"ACCUFIXRATE", (Object)"ACCULINESADDED", (Object)"ACCULINESCHANGED", (Object)"ACCULINESDELETED", (Object[])new String[]{"ALL", "AVGCYCLOMATICCOMPLEXITY", "BUILDRELATIONS", "CHANGEDFILES", "CHANGERATE", "CODINGSTANDARD", "COMPILERWARNING", "DEADCODE", "DUPLICATEDCODE", "ELOC", "FANOUT", "FINALIZE", "FIXRATE", "GLOC", "INCLUDERELATIONS", "INTEGRATIONTESTCOVERAGE", "LINESADDED", "LINESCHANGED", "LINESDELETED", "LOC", "MAXCYCLOMATICCOMPLEXITY", "PREPARE", "SECURITY", "SYSTEMTESTCOVERAGE", "TOTALTESTCOVERAGE", "UNITTESTCOVERAGE"});
    public final String projectName;
    public final String branchName;
    public List<String> calc;
    public List<String> recalc;
    public String ticsBin;
    public String ticsConfiguration;
    public String branchDirectory;
    public String extraArguments;
    public String tmpdir;
    public LinkedHashMap<String, String> environmentVariables;

    @DataBoundConstructor
    public TicsPipelineRun(String projectName, String branchName) {
        this.projectName = projectName;
        this.branchName = branchName;
    }

    public void perform(@Nonnull Run run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        boolean createTmpdir = !Strings.isNullOrEmpty((String)this.tmpdir);
        TicsAnalyzer ta = new TicsAnalyzer(this.ticsBin, this.ticsConfiguration, this.projectName, this.branchName, this.branchDirectory, this.convertEnvironmentVariablesToString(), createTmpdir, this.tmpdir, this.extraArguments, this.createMetricsObject(this.calc), this.createMetricsObject(this.recalc));
        ta.perform(run, workspace, launcher, listener);
    }

    private String convertEnvironmentVariablesToString() {
        return this.environmentVariables == null ? null : Joiner.on((String)"\n").withKeyValueSeparator("=").useForNull("").join(this.environmentVariables);
    }

    private Metrics createMetricsObject(@Nullable List<String> metrics) {
        if (metrics == null || metrics.isEmpty()) {
            return null;
        }
        List incorrectMetrics = metrics.stream().filter(a -> !ALL_METRICS.contains(a)).collect(Collectors.toList());
        if (!incorrectMetrics.isEmpty()) {
            throw new IllegalArgumentException("The following metrics are incorrect: " + incorrectMetrics + ". \nThe available metrics are: " + String.join((CharSequence)", ", ALL_METRICS));
        }
        return new Metrics(metrics.contains("ABSTRACTINTERPRETATION"), metrics.contains("ACCUCHANGERATE"), metrics.contains("ACCUFIXRATE"), metrics.contains("ACCULINESADDED"), metrics.contains("ACCULINESCHANGED"), metrics.contains("ACCULINESDELETED"), metrics.contains("ALL"), metrics.contains("AVGCYCLOMATICCOMPLEXITY"), metrics.contains("BUILDRELATIONS"), metrics.contains("CHANGEDFILES"), metrics.contains("CHANGERATE"), metrics.contains("CODINGSTANDARD"), metrics.contains("COMPILERWARNING"), metrics.contains("DEADCODE"), metrics.contains("DUPLICATEDCODE"), metrics.contains("ELOC"), metrics.contains("FANOUT"), metrics.contains("FINALIZE"), metrics.contains("FIXRATE"), metrics.contains("GLOC"), metrics.contains("INCLUDERELATIONS"), metrics.contains("INTEGRATIONTESTCOVERAGE"), metrics.contains("LINESADDED"), metrics.contains("LINESCHANGED"), metrics.contains("LINESDELETED"), metrics.contains("LOC"), metrics.contains("MAXCYCLOMATICCOMPLEXITY"), metrics.contains("PREPARE"), metrics.contains("SECURITY"), metrics.contains("SYSTEMTESTCOVERAGE"), metrics.contains("TOTALTESTCOVERAGE"), metrics.contains("UNITTESTCOVERAGE"));
    }

    @DataBoundSetter
    public void setRecalc(List<String> value) {
        this.recalc = value;
    }

    @DataBoundSetter
    public void setCalc(List<String> value) {
        this.calc = value;
    }

    @DataBoundSetter
    public void setTicsConfiguration(String value) {
        this.ticsConfiguration = value;
    }

    @DataBoundSetter
    public void setTicsBin(String value) {
        this.ticsBin = value;
    }

    @DataBoundSetter
    public void setBranchDirectory(String value) {
        this.branchDirectory = value;
    }

    @DataBoundSetter
    public void setExtraArguments(String value) {
        this.extraArguments = value;
    }

    @DataBoundSetter
    public void setTmpdir(String value) {
        this.tmpdir = value;
    }

    @DataBoundSetter
    public void setEnvironmentVariables(LinkedHashMap<String, String> value) {
        this.environmentVariables = value;
    }

    @Symbol(value={"runTics"})
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        @Nonnull
        public String getDisplayName() {
            return "";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

