/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tics;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import java.util.Map;

public class HtmlTag {
    private final String tag;
    private final ArrayListMultimap<String, String> attrs;

    private HtmlTag(String tag, ArrayListMultimap<String, String> attrs) {
        this.tag = tag;
        this.attrs = attrs;
    }

    public static HtmlTag from(String tag) {
        return new HtmlTag(tag, (ArrayListMultimap<String, String>)ArrayListMultimap.create());
    }

    public HtmlTag attr(String name, String value) {
        return this.attr(name, (Iterable<String>)ImmutableList.of((Object)value));
    }

    public HtmlTag attr(String name, Iterable<String> values) {
        ArrayListMultimap copy = ArrayListMultimap.create(this.attrs);
        copy.putAll((Object)name, values);
        return new HtmlTag(this.tag, (ArrayListMultimap<String, String>)copy);
    }

    public HtmlTag attrIf(boolean state, String key, String value) {
        if (state) {
            return this.attr(key, value);
        }
        return this;
    }

    public String open() {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(this.tag);
        if (this.attrs != null) {
            for (Map.Entry entry : this.attrs.asMap().entrySet()) {
                sb.append(" ");
                String valueSeparator = "style".equals(entry.getKey()) ? "; " : ("data-bind".equals(entry.getKey()) ? ", " : " ");
                sb.append((String)entry.getKey() + "=\"" + Joiner.on((String)valueSeparator).join((Iterable)entry.getValue()) + "\"");
            }
        }
        sb.append(">");
        return sb.toString();
    }

    public String close() {
        return "</" + this.tag + ">";
    }

    public String openClose() {
        return this.open() + this.close();
    }

    public String openClose(String inner) {
        return this.open() + inner + this.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tag", (Object)this.tag).toString();
    }
}

