/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tics;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.gson.Gson;
import hudson.plugins.tics.MeasureApiCall;
import hudson.plugins.tics.MeasureApiErrorResponse;
import java.io.PrintStream;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public abstract class AbstractApiCall {
    private final PrintStream logger;
    private final Optional<StandardUsernamePasswordCredentials> credentials;
    private final String apiCallPrefix;

    public AbstractApiCall(String apiCallName, PrintStream logger, Optional<StandardUsernamePasswordCredentials> credentials) {
        this.apiCallPrefix = apiCallName;
        this.logger = logger;
        this.credentials = credentials;
    }

    protected final CloseableHttpClient createHttpClient() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        HttpClientBuilder builder = HttpClients.custom();
        if (this.credentials.isPresent()) {
            String username = this.credentials.get().getUsername();
            String password = this.credentials.get().getPassword().getPlainText();
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            builder = builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        return builder.build();
    }

    protected void throwIfStatusNotOk(HttpResponse response, String body) throws MeasureApiCall.MeasureApiCallException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            return;
        }
        if (statusCode == 401) {
            if (this.credentials.isPresent()) {
                throw new MeasureApiCall.MeasureApiCallException(this.apiCallPrefix + " 401 Unauthorized - Invalid username/password combination");
            }
            throw new MeasureApiCall.MeasureApiCallException(this.apiCallPrefix + " 401 Unauthorized - Project requires authentication, but no credentials provided");
        }
        Optional<String> formattedError = this.tryExtractExceptionMessageFromBody(body);
        String reason = response.getStatusLine().getReasonPhrase();
        if (formattedError.isPresent()) {
            throw new MeasureApiCall.MeasureApiCallException(this.apiCallPrefix + " " + statusCode + " " + reason + " - " + formattedError.get());
        }
        this.logger.println(body);
        throw new MeasureApiCall.MeasureApiCallException(this.apiCallPrefix + " " + statusCode + " " + reason + " - See the build log for a detailed error report.");
    }

    private Optional<String> tryExtractExceptionMessageFromBody(String body) {
        if (body.startsWith("{")) {
            MeasureApiErrorResponse out;
            try {
                out = (MeasureApiErrorResponse)new Gson().fromJson(body, MeasureApiErrorResponse.class);
            }
            catch (Exception ex) {
                return Optional.empty();
            }
            if (out == null || out.alertMessages.size() == 0) {
                return Optional.empty();
            }
            MeasureApiErrorResponse.AlertMessage am0 = out.alertMessages.get(0);
            this.logger.println(am0.stackTrace);
            return Optional.ofNullable(am0.message);
        }
        Matcher matcher = Pattern.compile("Exception: ([^\n]+)").matcher(body);
        if (matcher.find()) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }
}

