/*
 * Decompiled with CFR 0.152.
 */
package com.thycotic.secrets.jenkins;

import com.thycotic.secrets.jenkins.ClientSecret;
import com.thycotic.secrets.jenkins.VaultConfiguration;
import com.thycotic.secrets.jenkins.VaultSecret;
import com.thycotic.secrets.vault.spring.Secret;
import com.thycotic.secrets.vault.spring.SecretsVault;
import com.thycotic.secrets.vault.spring.SecretsVaultFactoryBean;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import jenkins.tasks.SimpleBuildWrapper;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class VaultBuildWrapper
extends SimpleBuildWrapper {
    private static final String CLIENT_ID_PROPERTY = "secrets_vault.client_id";
    private static final String CLIENT_SECRET_PROPERTY = "secrets_vault.client_secret";
    private static final String TENANT_PROPERTY = "secrets_vault.tenant";
    private static final String TLD_PROPERTY = "secrets_vault.tld";
    private List<VaultSecret> secrets;

    @DataBoundConstructor
    public VaultBuildWrapper(List<VaultSecret> secrets) {
        this.secrets = secrets;
    }

    public List<VaultSecret> getSecrets() {
        return this.secrets;
    }

    @DataBoundSetter
    public void setSecrets(List<VaultSecret> secrets) {
        this.secrets = secrets;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        VaultConfiguration configuration = VaultConfiguration.get();
        HashMap properties = new HashMap();
        this.secrets.forEach(vaultSecret -> {
            String overrideCredentialId = vaultSecret.getCredentialId();
            ClientSecret clientSecret = StringUtils.isNotBlank((String)overrideCredentialId) ? ClientSecret.get(overrideCredentialId, null) : ClientSecret.get(configuration.getCredentialId(), null);
            assert (clientSecret != null);
            AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext();
            properties.put(CLIENT_ID_PROPERTY, clientSecret.getClientId());
            properties.put(CLIENT_SECRET_PROPERTY, clientSecret.getSecret());
            properties.put(TENANT_PROPERTY, StringUtils.defaultIfBlank((String)vaultSecret.getTenant(), (String)configuration.getTenant()));
            properties.put(TLD_PROPERTY, StringUtils.defaultIfBlank((String)vaultSecret.getTld(), (String)configuration.getTld()));
            applicationContext.getEnvironment().getPropertySources().addLast((PropertySource)new MapPropertySource("properties", properties));
            applicationContext.registerBean(SecretsVaultFactoryBean.class, new BeanDefinitionCustomizer[0]);
            applicationContext.refresh();
            Secret secret = ((SecretsVault)applicationContext.getBean(SecretsVault.class)).getSecret(vaultSecret.getPath());
            vaultSecret.getMappings().forEach(mapping -> context.env(StringUtils.trimToEmpty((String)((VaultConfiguration)((Object)((Object)((Object)ExtensionList.lookupSingleton(VaultConfiguration.class))))).getEnvironmentVariablePrefix()) + mapping.getEnvironmentVariable(), (String)secret.getData().get(mapping.getDataField())));
            applicationContext.close();
        });
    }

    @Extension
    @Symbol(value={"withDevOpsSecretsVault"})
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Use Thycotic DevOps Secrets Vault Secrets";
        }
    }
}

