/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.teamstrigger.whitelist;

import com.google.common.base.Optional;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.teamstrigger.global.CredentialsHelper;
import org.jenkinsci.plugins.teamstrigger.global.Whitelist;
import org.jenkinsci.plugins.teamstrigger.global.WhitelistItem;
import org.jenkinsci.plugins.teamstrigger.whitelist.HMACVerifier;
import org.jenkinsci.plugins.teamstrigger.whitelist.HostVerifier;
import org.jenkinsci.plugins.teamstrigger.whitelist.WhitelistException;
import org.jenkinsci.plugins.teamstrigger.whitelist.WhitelistHost;

public class WhitelistVerifier {
    public static void verifyWhitelist(String remoteHost, Map<String, List<String>> headers, String postContent) throws WhitelistException {
        Whitelist whitelist = Whitelist.get();
        WhitelistVerifier.doVerifyWhitelist(remoteHost, headers, postContent, whitelist);
    }

    static void doVerifyWhitelist(String remoteHost, Map<String, List<String>> headers, String postContent, Whitelist whitelist) throws WhitelistException {
        if (whitelist.getWhitelistItems().isEmpty() || !whitelist.isEnabled()) {
            return;
        }
        StringBuilder messages = new StringBuilder();
        int i = 0;
        for (WhitelistItem whitelistItem : whitelist.getWhitelistItems()) {
            ++i;
            try {
                WhitelistVerifier.whitelistVerify(remoteHost, whitelistItem, headers, postContent);
                return;
            }
            catch (WhitelistException e) {
                messages.append(i + ") " + e.getMessage() + "\n");
            }
        }
        String messagesString = messages.toString();
        throw new WhitelistException("Did not find a matching whitelisted host:\n" + messagesString);
    }

    static void whitelistVerify(String remoteHost, WhitelistItem whitelistItem, Map<String, List<String>> headers, String postContent) throws WhitelistException {
        WhitelistHost whitelistHost = new WhitelistHost(whitelistItem.getHost());
        if (HostVerifier.whitelistVerified(new WhitelistHost(remoteHost), whitelistHost)) {
            if (whitelistItem.isHmacEnabled()) {
                Optional<StringCredentials> hmacKeyOpt = CredentialsHelper.findCredentials(whitelistItem.getHmacCredentialId());
                if (!hmacKeyOpt.isPresent()) {
                    throw new WhitelistException("Was unable to find secret text credential " + whitelistItem.getHmacCredentialId());
                }
                String hmacHeader = whitelistItem.getHmacHeader();
                String hmacKey = ((StringCredentials)hmacKeyOpt.get()).getSecret().getPlainText();
                HMACVerifier.hmacVerify(headers, postContent, hmacHeader, hmacKey);
                return;
            }
            return;
        }
        throw new WhitelistException("Sending host \"" + remoteHost + "\" was not matched by whitelist.");
    }
}

