/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.teamstrigger.whitelist;

import com.github.jgonian.ipmath.Ipv4;
import com.github.jgonian.ipmath.Ipv4Range;
import com.github.jgonian.ipmath.Ipv6;
import com.github.jgonian.ipmath.Ipv6Range;
import com.google.common.net.InetAddresses;
import org.jenkinsci.plugins.teamstrigger.whitelist.WhitelistException;

public class WhitelistHost {
    private HOST_TYPE hostType;
    private String whitelistHost;
    private String rangeLeftValue;
    private String rangeRightValue;
    private Ipv4 staticIpv4;
    private Ipv6 staticIpv6;
    private Ipv6Range rangeIpv6;
    private Ipv4Range rangeIpv4;

    public WhitelistHost(String string) throws WhitelistException {
        if (string == null || string.trim().isEmpty()) {
            this.hostType = HOST_TYPE.ANY;
            this.whitelistHost = "";
            return;
        }
        this.hostType = HOST_TYPE.STATIC;
        this.whitelistHost = string.trim();
        String[] hostParts = this.whitelistHost.split("/");
        boolean isCidrRange = false;
        if (hostParts.length == 2) {
            this.hostType = HOST_TYPE.CIDR;
        } else {
            hostParts = this.whitelistHost.split("-");
            if (hostParts.length == 2) {
                isCidrRange = true;
                this.hostType = HOST_TYPE.CIDR;
            }
        }
        if (this.hostType == HOST_TYPE.CIDR) {
            int leftValueLength;
            try {
                leftValueLength = InetAddresses.forString((String)hostParts[0]).getAddress().length;
            }
            catch (IllegalArgumentException e) {
                throw new WhitelistException(this.whitelistHost + " is not an Ipv4 string literal.");
            }
            if (leftValueLength == 4) {
                try {
                    this.rangeIpv4 = Ipv4Range.parse((String)this.whitelistHost);
                }
                catch (IllegalArgumentException e) {
                    throw new WhitelistException(this.whitelistHost + " cannot be parsed as Ipv4 string literal.");
                }
            }
            if (leftValueLength == 16) {
                try {
                    this.rangeIpv6 = Ipv6Range.parse((String)this.whitelistHost);
                }
                catch (IllegalArgumentException e) {
                    throw new WhitelistException(this.whitelistHost + " cannot be parsed as Ipv6 string literal.");
                }
            }
            if (isCidrRange) {
                String leftValue = hostParts[0];
                String rightValue = hostParts[1];
                try {
                    InetAddresses.isInetAddress((String)leftValue);
                    this.rangeLeftValue = leftValue;
                }
                catch (IllegalArgumentException e) {
                    throw new WhitelistException("Left part of range, " + leftValue + ", is not an IP string literal.");
                }
                try {
                    InetAddresses.isInetAddress((String)rightValue);
                    this.rangeRightValue = rightValue;
                }
                catch (IllegalArgumentException e) {
                    throw new WhitelistException("Right part of range, " + rightValue + ", is not an IP string literal.");
                }
            }
        } else if (this.hostType == HOST_TYPE.STATIC) {
            int valueLength = -1;
            try {
                valueLength = InetAddresses.forString((String)hostParts[0]).getAddress().length;
            }
            catch (IllegalArgumentException e) {
                throw new WhitelistException(this.whitelistHost + " is not a valid IP string literal.");
            }
            if (valueLength == 4) {
                try {
                    this.staticIpv4 = Ipv4.parse((String)this.whitelistHost);
                }
                catch (IllegalArgumentException e) {
                    throw new WhitelistException(this.whitelistHost + " is not a valid Ipv4 string literal. " + e.getMessage());
                }
            }
            if (valueLength == 16) {
                try {
                    this.staticIpv6 = Ipv6.parse((String)this.whitelistHost);
                }
                catch (IllegalArgumentException e) {
                    throw new WhitelistException(this.whitelistHost + " is not a valid Ipv6 string literal. " + e.getMessage());
                }
            }
            if (!InetAddresses.isInetAddress((String)this.whitelistHost)) {
                throw new WhitelistException(this.whitelistHost + " is not a valid IP string literal.");
            }
        }
    }

    public HOST_TYPE getHostType() {
        return this.hostType;
    }

    public String getWhitelistHost() {
        return this.whitelistHost;
    }

    public Ipv4Range getRangeIpv4() {
        return this.rangeIpv4;
    }

    public Ipv6Range getRangeIpv6() {
        return this.rangeIpv6;
    }

    public String getRangeLeftValue() {
        return this.rangeLeftValue;
    }

    public String getRangeRightValue() {
        return this.rangeRightValue;
    }

    public Ipv4 getStaticIpv4() {
        return this.staticIpv4;
    }

    public Ipv6 getStaticIpv6() {
        return this.staticIpv6;
    }

    public static enum HOST_TYPE {
        CIDR,
        STATIC,
        ANY;

    }
}

