/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.teamstrigger.whitelist;

import com.github.jgonian.ipmath.Ipv4Range;
import com.github.jgonian.ipmath.Ipv6Range;
import com.github.jgonian.ipmath.Range;
import org.jenkinsci.plugins.teamstrigger.whitelist.WhitelistException;
import org.jenkinsci.plugins.teamstrigger.whitelist.WhitelistHost;

public class HostVerifier {
    static boolean whitelistVerified(WhitelistHost remoteHost, WhitelistHost whitelistHost) throws WhitelistException {
        if (whitelistHost.getWhitelistHost().equalsIgnoreCase(remoteHost.getWhitelistHost())) {
            return true;
        }
        switch (whitelistHost.getHostType()) {
            case ANY: {
                return true;
            }
            case CIDR: {
                return HostVerifier.verifyCidr(remoteHost, whitelistHost);
            }
            case STATIC: {
                return HostVerifier.verifyStatic(remoteHost, whitelistHost);
            }
        }
        throw new WhitelistException("Did not identify type of " + whitelistHost.getWhitelistHost());
    }

    private static boolean verifyStatic(WhitelistHost remoteHost, WhitelistHost whitelistHost) throws WhitelistException {
        if (whitelistHost.getStaticIpv4() != null && remoteHost.getStaticIpv4() != null) {
            if (whitelistHost.getStaticIpv4().equals((Object)remoteHost.getStaticIpv4())) {
                return true;
            }
            throw new WhitelistException(remoteHost.getWhitelistHost() + " did not match statically defined Ipv4.");
        }
        if (whitelistHost.getStaticIpv6() != null && remoteHost.getStaticIpv6() != null) {
            if (whitelistHost.getStaticIpv6().equals((Object)remoteHost.getStaticIpv6())) {
                return true;
            }
            throw new WhitelistException(remoteHost.getWhitelistHost() + " did not match statically defined Ipv6.");
        }
        throw new WhitelistException(remoteHost.getWhitelistHost() + " is not of same IP version as statically defined IP.");
    }

    private static boolean verifyCidr(WhitelistHost remoteHost, WhitelistHost whitelistHost) throws WhitelistException {
        if (whitelistHost.getRangeIpv4() != null && remoteHost.getStaticIpv4() != null) {
            if (whitelistHost.getRangeIpv4().overlaps((Range)Ipv4Range.parse((String)(remoteHost.getWhitelistHost() + "/32")))) {
                return true;
            }
            throw new WhitelistException(remoteHost.getWhitelistHost() + " did not match Ipv4 range.");
        }
        if (whitelistHost.getRangeIpv6() != null && remoteHost.getStaticIpv6() != null) {
            if (whitelistHost.getRangeIpv6().overlaps((Range)Ipv6Range.parse((String)(remoteHost.getWhitelistHost() + "/128")))) {
                return true;
            }
            throw new WhitelistException(remoteHost.getWhitelistHost() + " did not match Ipv6 range.");
        }
        throw new WhitelistException(remoteHost.getWhitelistHost() + " is not of same IP version as statically defined IP.");
    }
}

