/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.teamstrigger.whitelist;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jenkinsci.plugins.teamstrigger.global.WhitelistAlgorithm;
import org.jenkinsci.plugins.teamstrigger.whitelist.WhitelistException;

public class HMACVerifier {
    public static void hmacVerify(Map<String, List<String>> headers, String postContent, String hmacHeader, String hmacSecret) throws WhitelistException {
        String headerValue = HMACVerifier.getHeaderValue(hmacHeader, headers);
        byte[] calculateHmacBytes = HMACVerifier.getCalculatedHmac(postContent, hmacSecret);
        String calculateHmacAsHex = HMACVerifier.bytesToHex(calculateHmacBytes);
        String calculateHmacAsString = Base64.getEncoder().encodeToString(calculateHmacBytes);
        if (!headerValue.equalsIgnoreCase(calculateHmacAsHex) && !headerValue.equalsIgnoreCase(calculateHmacAsString)) {
            throw new WhitelistException("HMAC verification failed with \"" + hmacHeader + "\" as \"" + headerValue);
        }
    }

    private static byte[] getCalculatedHmac(String postContent, String hmacSecret) {
        try {
            byte[] hash = Base64.getDecoder().decode(hmacSecret);
            Mac mac = Mac.getInstance(WhitelistAlgorithm.HMAC_SHA256.getFullName());
            SecretKeySpec keySpec = new SecretKeySpec(hash, WhitelistAlgorithm.HMAC_SHA256.getFullName());
            mac.init(keySpec);
            return mac.doFinal(postContent.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static String getHeaderValue(String hmacHeader, Map<String, List<String>> headers) throws WhitelistException {
        for (Map.Entry<String, List<String>> ck : headers.entrySet()) {
            boolean oneValue;
            boolean sameHeader = ck.getKey().equalsIgnoreCase(hmacHeader);
            boolean bl = oneValue = ck.getValue().size() == 1;
            if (!sameHeader || !oneValue) continue;
            String value = ck.getValue().get(0);
            for (WhitelistAlgorithm algorithm : WhitelistAlgorithm.values()) {
                String startStringHmac = "HMAC ";
                if (!value.startsWith("HMAC ")) continue;
                return value.substring("HMAC ".length()).trim();
            }
            return value;
        }
        throw new WhitelistException("Was unable to find header with name \"" + hmacHeader + "\" among " + headers);
    }
}

