/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.teamstrigger.resolvers;

import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.teamstrigger.GenericHeaderVariable;
import org.jenkinsci.plugins.teamstrigger.resolvers.FlattenerUtils;

public class RequestHeaderResolver {
    public Map<String, String> getRequestHeaders(List<GenericHeaderVariable> configuredGenericHeaderVariables, Map<String, List<String>> incomingHeaders) {
        HashMap<String, String> found = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> headersEntry : incomingHeaders.entrySet()) {
            String headerName = headersEntry.getKey();
            Optional<GenericHeaderVariable> configuredVariable = this.findConfiguredVariable(configuredGenericHeaderVariables, headerName);
            if (!configuredVariable.isPresent()) continue;
            List<String> headers = headersEntry.getValue();
            int i = 0;
            for (String headerValue : headers) {
                boolean firstValue;
                String regexpFilter = ((GenericHeaderVariable)((Object)configuredVariable.get())).getRegexpFilter();
                String filteredValue = FlattenerUtils.filter(headerValue, regexpFilter);
                found.put(FlattenerUtils.toVariableName(headerName).toLowerCase() + "_" + i, filteredValue);
                boolean bl = firstValue = i == 0;
                if (firstValue) {
                    found.put(FlattenerUtils.toVariableName(headerName).toLowerCase(), filteredValue);
                }
                ++i;
            }
            incomingHeaders.put(headerName, headers);
        }
        return found;
    }

    private Optional<GenericHeaderVariable> findConfiguredVariable(List<GenericHeaderVariable> configuredGenericHeaderVariables, String headerName) {
        for (GenericHeaderVariable ghv : configuredGenericHeaderVariables) {
            if (!ghv.getHeaderName().equalsIgnoreCase(headerName)) continue;
            return Optional.of((Object)((Object)ghv));
        }
        return Optional.absent();
    }
}

