/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.teamstrigger.global;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import org.jenkinsci.plugins.teamstrigger.global.CredentialsHelper;
import org.jenkinsci.plugins.teamstrigger.global.WhitelistAlgorithm;
import org.jenkinsci.plugins.teamstrigger.whitelist.WhitelistException;
import org.jenkinsci.plugins.teamstrigger.whitelist.WhitelistHost;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class WhitelistItem
extends AbstractDescribableImpl<WhitelistItem>
implements Serializable {
    private static final long serialVersionUID = 1176246137502450635L;
    private String host;
    private boolean hmacEnabled;
    private String hmacHeader;
    private String hmacCredentialId;

    public WhitelistItem() {
    }

    @DataBoundConstructor
    public WhitelistItem(String host) {
        this.host = host;
    }

    public String getHost() {
        if (this.host == null) {
            return null;
        }
        return this.host.trim();
    }

    public String getHmacCredentialId() {
        return this.hmacCredentialId;
    }

    @DataBoundSetter
    public void setHmacCredentialId(String hmacCredentialId) {
        this.hmacCredentialId = hmacCredentialId;
    }

    public boolean isHmacEnabled() {
        return this.hmacEnabled;
    }

    @DataBoundSetter
    public void setHmacEnabled(boolean hmacEnabled) {
        this.hmacEnabled = hmacEnabled;
    }

    public String getHmacHeader() {
        return this.hmacHeader;
    }

    @DataBoundSetter
    public void setHmacHeader(String hmacHeader) {
        this.hmacHeader = hmacHeader;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<WhitelistItem> {
        @NonNull
        public String getDisplayName() {
            return "Whitelist item";
        }

        public ListBoxModel doFillHmacAlgorithmItems() {
            ListBoxModel listBoxModel = new ListBoxModel();
            for (WhitelistAlgorithm a : WhitelistAlgorithm.values()) {
                listBoxModel.add(a.getFullName());
            }
            return listBoxModel;
        }

        public ListBoxModel doFillHmacCredentialIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            return CredentialsHelper.doFillCredentialsIdItems(item, credentialsId);
        }

        public FormValidation doCheckHmacCredentialIdItems(@QueryParameter String value) {
            return CredentialsHelper.doCheckFillCredentialsId(value);
        }

        public FormValidation doCheckHost(@QueryParameter String value) {
            try {
                new WhitelistHost(value);
                return FormValidation.ok();
            }
            catch (WhitelistException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

