/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.teamstrigger;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.List;
import java.util.Map;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.teamstrigger.GenericCause;
import org.jenkinsci.plugins.teamstrigger.GenericHeaderVariable;
import org.jenkinsci.plugins.teamstrigger.GenericRequestVariable;
import org.jenkinsci.plugins.teamstrigger.GenericTriggerResults;
import org.jenkinsci.plugins.teamstrigger.GenericVariable;
import org.jenkinsci.plugins.teamstrigger.ParameterActionUtil;
import org.jenkinsci.plugins.teamstrigger.Renderer;
import org.jenkinsci.plugins.teamstrigger.global.CredentialsHelper;
import org.jenkinsci.plugins.teamstrigger.resolvers.VariablesResolver;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class TeamsTrigger
extends Trigger<Job<?, ?>> {
    private List<GenericVariable> genericVariables = Lists.newArrayList();
    private final String regexpFilterText;
    private final String regexpFilterExpression;
    private List<GenericRequestVariable> genericRequestVariables = Lists.newArrayList();
    private List<GenericHeaderVariable> genericHeaderVariables = Lists.newArrayList();
    private boolean printPostContent;
    private boolean printContributedVariables;
    private String causeString;
    private String token;
    private String tokenCredentialId;
    private boolean silentResponse;
    private boolean overrideQuietPeriod;
    private boolean requestFromTeams;
    private String textSeparator;
    @Extension
    public static final TeamsDescriptor DESCRIPTOR = new TeamsDescriptor();

    @DataBoundConstructor
    public TeamsTrigger(List<GenericVariable> genericVariables, String regexpFilterText, String regexpFilterExpression, List<GenericRequestVariable> genericRequestVariables, List<GenericHeaderVariable> genericHeaderVariables) {
        this.genericVariables = genericVariables;
        this.regexpFilterExpression = regexpFilterExpression;
        this.regexpFilterText = regexpFilterText;
        this.genericRequestVariables = genericRequestVariables;
        this.genericHeaderVariables = genericHeaderVariables;
    }

    @DataBoundSetter
    public void setCauseString(String causeString) {
        this.causeString = causeString;
    }

    public String getCauseString() {
        return this.causeString;
    }

    @DataBoundSetter
    public void setPrintContributedVariables(boolean printContributedVariables) {
        this.printContributedVariables = printContributedVariables;
    }

    @DataBoundSetter
    public void setPrintPostContent(boolean printPostContent) {
        this.printPostContent = printPostContent;
    }

    @DataBoundSetter
    public void setSilentResponse(boolean silentResponse) {
        this.silentResponse = silentResponse;
    }

    @DataBoundSetter
    public void setOverrideQuietPeriod(boolean overrideQuietPeriod) {
        this.overrideQuietPeriod = overrideQuietPeriod;
    }

    public boolean getOverrideQuietPeriod() {
        return this.overrideQuietPeriod;
    }

    @DataBoundSetter
    public void setValuesFromTextKey(boolean requestFromTeams) {
        this.requestFromTeams = requestFromTeams;
    }

    public boolean getValuesFromTextKey() {
        return this.requestFromTeams;
    }

    @DataBoundSetter
    public void setTextSeparator(String textSeparator) {
        this.textSeparator = textSeparator;
    }

    public String getTextSeparator() {
        return this.textSeparator;
    }

    public boolean isSilentResponse() {
        return this.silentResponse;
    }

    public boolean isPrintContributedVariables() {
        return this.printContributedVariables;
    }

    public boolean isPrintPostContent() {
        return this.printPostContent;
    }

    @DataBoundSetter
    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    @DataBoundSetter
    public void setTokenCredentialId(String tokenCredentialId) {
        this.tokenCredentialId = tokenCredentialId;
    }

    public String getTokenCredentialId() {
        return this.tokenCredentialId;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT", "NP_NULL_ON_SOME_PATH"})
    public GenericTriggerResults trigger(Map<String, List<String>> headers, Map<String, String[]> parameterMap, String postContent, int quietPeriod) {
        Map<String, String> resolvedVariables = new VariablesResolver(headers, parameterMap, postContent, this.genericVariables, this.genericRequestVariables, this.genericHeaderVariables, this.textSeparator, this.requestFromTeams).getVariables();
        String renderedRegexpFilterText = Renderer.renderText(this.regexpFilterText, resolvedVariables);
        boolean isMatching = Renderer.isMatching(renderedRegexpFilterText, this.regexpFilterExpression);
        Queue.Item item = null;
        if (isMatching) {
            String cause = Renderer.renderText(this.causeString, resolvedVariables);
            GenericCause genericCause = new GenericCause(postContent, resolvedVariables, this.printContributedVariables, this.printPostContent, cause);
            ParametersDefinitionProperty parametersDefinitionProperty = (ParametersDefinitionProperty)((Job)this.job).getProperty(ParametersDefinitionProperty.class);
            ParametersAction parameters = ParameterActionUtil.createParameterAction(parametersDefinitionProperty, resolvedVariables);
            this.retrieveScheduleJob((Job)this.job);
            item = ParameterizedJobMixIn.scheduleBuild2((Job)((Job)this.job), (int)quietPeriod, (Action[])new Action[]{new CauseAction((Cause)genericCause), parameters});
        }
        return new GenericTriggerResults(item, renderedRegexpFilterText, this.regexpFilterExpression);
    }

    private ParameterizedJobMixIn<?, ?> retrieveScheduleJob(final Job<?, ?> job) {
        return new ParameterizedJobMixIn(){

            protected Job<?, ?> asJob() {
                return job;
            }
        };
    }

    public List<GenericVariable> getGenericVariables() {
        return this.genericVariables;
    }

    public String getRegexpFilterExpression() {
        return this.regexpFilterExpression;
    }

    public List<GenericRequestVariable> getGenericRequestVariables() {
        return this.genericRequestVariables;
    }

    public List<GenericHeaderVariable> getGenericHeaderVariables() {
        return this.genericHeaderVariables;
    }

    public String getRegexpFilterText() {
        return this.regexpFilterText;
    }

    public String toString() {
        return "GenericTrigger [genericVariables=" + this.genericVariables + ", regexpFilterText=" + this.regexpFilterText + ", regexpFilterExpression=" + this.regexpFilterExpression + ", genericRequestVariables=" + this.genericRequestVariables + ", genericHeaderVariables=" + this.genericHeaderVariables + "]";
    }

    @Symbol(value={"TeamsTrigger"})
    public static class TeamsDescriptor
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return Job.class.isAssignableFrom(item.getClass());
        }

        public String getDisplayName() {
            return "Teams Webhook Trigger";
        }

        public ListBoxModel doFillTokenCredentialIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            return CredentialsHelper.doFillCredentialsIdItems(item, credentialsId);
        }

        public FormValidation doCheckTokenCredentialIdItems(@QueryParameter String value) {
            return CredentialsHelper.doCheckFillCredentialsId(value);
        }
    }
}

