/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.teamstrigger;

import com.google.common.base.Charsets;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.teamstrigger.GenericCause;

@Extension
public class GenericWebhookEnvironmentContributor
extends EnvironmentContributor {
    private static final String CONTRIBUTING_VARIABLES = GenericWebhookEnvironmentContributor.class.getSimpleName();

    public void buildEnvironmentFor(@Nonnull Run r, @Nonnull EnvVars envs, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        GenericCause cause = (GenericCause)r.getCause(GenericCause.class);
        if (cause != null) {
            boolean shouldLog;
            boolean bl = shouldLog = (cause.isPrintContributedVariables() || cause.isPrintPostContent()) && this.notLogged(r);
            if (shouldLog && cause.isPrintPostContent()) {
                listener.getLogger().println(CONTRIBUTING_VARIABLES);
                listener.getLogger().println(" Received:\n\n" + cause.getPostContent() + "\n\n");
            }
            Map<String, String> resolvedVariables = cause.getResolvedVariables();
            if (shouldLog && cause.isPrintContributedVariables()) {
                listener.getLogger().println("Contributing variables:\n");
            }
            for (String variable : resolvedVariables.keySet()) {
                String resolved = cause.getResolvedVariables().get(variable);
                if (shouldLog && cause.isPrintContributedVariables()) {
                    listener.getLogger().println("    " + variable + " = " + resolved);
                }
                envs.override(variable, resolved);
            }
            if (shouldLog && cause.isPrintContributedVariables()) {
                listener.getLogger().println("\n");
            }
        }
    }

    private boolean notLogged(Run r) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(r.getLogInputStream(), Charsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.contains(CONTRIBUTING_VARIABLES)) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }
}

