/*
 * Decompiled with CFR 0.152.
 */
package s3explorer;

import hudson.Plugin;
import hudson.util.Secret;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class S3ExplorerPlugin
extends Plugin
implements Serializable {
    private static final long serialVersionUID = 26L;
    private static final Logger LOG = Logger.getLogger(S3ExplorerPlugin.class.getName());
    private String awsRegion = "";
    private Secret awsAccessKeyId = Secret.fromString((String)"");
    private Secret awsSecretAccessKey = Secret.fromString((String)"");
    private String bucketName = "";

    public void start() throws Exception {
        LOG.info("Starting s3explorer.S3ExplorerPlugin");
        String jenkinsHome = Jenkins.get().getRootDir().getPath();
        LOG.info("Root dir = " + jenkinsHome);
        this.load();
        LOG.info("Loaded s3explorer.S3ExplorerPlugin's configuration successfully");
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException {
        this.setAwsRegion(formData.optString("awsRegion"));
        this.setAwsAccessKeyId(formData.optString("awsAccessKeyId"));
        this.setAwsSecretAccessKey(formData.optString("awsSecretAccessKey"));
        this.setBucketName(formData.optString("bucketName"));
        this.save();
        LOG.info("Saved s3explorer.S3ExplorerPlugin's configuration successfully");
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId.getPlainText();
    }

    public String getAwsSecretAccessKey() {
        return this.awsSecretAccessKey.getPlainText();
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    public void setAwsAccessKeyId(String awsAccessKeyId) {
        this.awsAccessKeyId = Secret.fromString((String)awsAccessKeyId);
    }

    public void setAwsSecretAccessKey(String awsSecretAccessKey) {
        this.awsSecretAccessKey = Secret.fromString((String)awsSecretAccessKey);
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }
}

