/*
 * Decompiled with CFR 0.152.
 */
package redhat.jenkins.plugins.rhda.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Map;
import redhat.jenkins.plugins.rhda.utils.Utils;

public class CommandExecutor {
    private String getPrompt() {
        if (Utils.isWindows()) {
            return "cmd.exe";
        }
        return "bash";
    }

    private String getCmd() {
        if (Utils.isWindows()) {
            return "/c";
        }
        return "-c";
    }

    public ProcessBuilder setEnv(ProcessBuilder processBuilder, Map<String, String> envs) {
        Map<String, String> env = processBuilder.environment();
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            env.put(entry.getKey(), entry.getValue());
        }
        return processBuilder;
    }

    public String execute(String command, PrintStream logger) {
        return this.execute(command, logger, null);
    }

    public String execute(String command, PrintStream logger, Map<String, String> envs) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (envs != null) {
            processBuilder = this.setEnv(processBuilder, envs);
        }
        processBuilder.command(this.getPrompt(), this.getCmd(), command);
        try {
            String line;
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            StringBuilder output = new StringBuilder();
            InputStreamReader isr = new InputStreamReader(process.getInputStream(), "UTF-8");
            BufferedReader reader = new BufferedReader(isr);
            while ((line = reader.readLine()) != null) {
                output.append(line + "\n");
            }
            reader.close();
            isr.close();
            int exitVal = process.waitFor();
            if (exitVal == 0 || exitVal == 2) {
                logger.println("Success!");
                return output.toString();
            }
            logger.println("Abnormal Interruption!");
            logger.println("Status returned from CLI:" + exitVal);
            logger.println(output.toString());
            return String.valueOf(exitVal);
        }
        catch (IOException e) {
            logger.println(e);
        }
        catch (InterruptedException e) {
            logger.println(e);
        }
        return "";
    }
}

