/*
 * Decompiled with CFR 0.152.
 */
package redhat.jenkins.plugins.rhda.step;

import com.redhat.exhort.Api;
import com.redhat.exhort.api.AnalysisReport;
import com.redhat.exhort.api.DependenciesSummary;
import com.redhat.exhort.api.ProviderStatus;
import com.redhat.exhort.api.VulnerabilitiesSummary;
import com.redhat.exhort.impl.ExhortApi;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.ArtifactArchiver;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletException;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import redhat.jenkins.plugins.rhda.action.CRDAAction;
import redhat.jenkins.plugins.rhda.task.CRDABuilder;
import redhat.jenkins.plugins.rhda.utils.RHDAGlobalConfig;

public final class CRDAStep
extends Step {
    private String file;
    private boolean consentTelemetry = false;

    @DataBoundConstructor
    public CRDAStep(String file, boolean consentTelemetry) {
        this.file = file;
        this.consentTelemetry = consentTelemetry;
    }

    public String getFile() {
        return this.file;
    }

    @DataBoundSetter
    public void setFile(String file) {
        this.file = file;
    }

    public boolean getConsentTelemetry() {
        return this.consentTelemetry;
    }

    @DataBoundSetter
    public void setConsentTelemetry(boolean consentTelemetry) {
        this.consentTelemetry = consentTelemetry;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Extension
    @Symbol(value={"rhdaAnalysis"})
    public static class DescriptorImpl
    extends StepDescriptor {
        private final CRDABuilder.BuilderDescriptorImpl builderDescriptor = new CRDABuilder.BuilderDescriptorImpl();

        public FormValidation doCheckFile(@QueryParameter String file) throws IOException, ServletException {
            return this.builderDescriptor.doCheckFile(file);
        }

        public String getFunctionName() {
            return "rhdaAnalysis";
        }

        public String getDisplayName() {
            return "Invoke Red Hat Dependency Analytics (RHDA)";
        }

        public Set<Class<?>> getRequiredContext() {
            return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(FilePath.class, Run.class, TaskListener.class)));
        }
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<String> {
        private final transient CRDAStep step;
        private String jenkinsPath;
        private static final long serialVersionUID = 1L;

        protected Execution(CRDAStep step, StepContext context) {
            super(context);
            this.step = step;
            try {
                EnvVars envVars = (EnvVars)context.get(EnvVars.class);
                this.jenkinsPath = (String)envVars.get((Object)"PATH");
                if (envVars.get((Object)"EXHORT_MVN_PATH") != null) {
                    System.setProperty("EXHORT_MVN_PATH", (String)envVars.get((Object)"EXHORT_MVN_PATH"));
                } else {
                    System.clearProperty("EXHORT_MVN_PATH");
                }
                if (envVars.get((Object)"EXHORT_NPM_PATH") != null) {
                    System.setProperty("EXHORT_NPM_PATH", (String)envVars.get((Object)"EXHORT_NPM_PATH"));
                } else {
                    System.clearProperty("EXHORT_NPM_PATH");
                }
                if (envVars.get((Object)"EXHORT_GO_PATH") != null) {
                    System.setProperty("EXHORT_GO_PATH", (String)envVars.get((Object)"EXHORT_GO_PATH"));
                } else {
                    System.clearProperty("EXHORT_GO_PATH");
                }
                if (envVars.get((Object)"EXHORT_URL") != null) {
                    System.setProperty("EXHORT_URL", (String)envVars.get((Object)"EXHORT_URL"));
                } else {
                    System.clearProperty("EXHORT_URL");
                }
                if (envVars.get((Object)"EXHORT_SNYK_TOKEN") != null) {
                    System.setProperty("EXHORT_SNYK_TOKEN", (String)envVars.get((Object)"EXHORT_SNYK_TOKEN"));
                } else {
                    System.clearProperty("EXHORT_SNYK_TOKEN");
                }
                if (envVars.get((Object)"EXHORT_PYTHON3_PATH") != null) {
                    System.setProperty("EXHORT_PYTHON3_PATH", (String)envVars.get((Object)"EXHORT_PYTHON3_PATH"));
                } else {
                    System.clearProperty("EXHORT_PYTHON3_PATH");
                }
                if (envVars.get((Object)"EXHORT_PIP3_PATH") != null) {
                    System.setProperty("EXHORT_PIP3_PATH", (String)envVars.get((Object)"EXHORT_PIP3_PATH"));
                } else {
                    System.clearProperty("EXHORT_PIP3_PATH");
                }
                if (envVars.get((Object)"EXHORT_PYTHON_PATH") != null) {
                    System.setProperty("EXHORT_PYTHON_PATH", (String)envVars.get((Object)"EXHORT_PYTHON_PATH"));
                } else {
                    System.clearProperty("EXHORT_PYTHON_PATH");
                }
                if (envVars.get((Object)"EXHORT_PIP_PATH") != null) {
                    System.setProperty("EXHORT_PIP_PATH", (String)envVars.get((Object)"EXHORT_PIP_PATH"));
                } else {
                    System.clearProperty("EXHORT_PIP_PATH");
                }
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        }

        protected String run() throws Exception {
            String crdaUuid;
            PrintStream logger = ((TaskListener)this.getContext().get(TaskListener.class)).getLogger();
            logger.println("Red Hat Dependency Analytics Begin");
            Run run = (Run)this.getContext().get(Run.class);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
            RHDAGlobalConfig globalConfig = RHDAGlobalConfig.get();
            if (RHDAGlobalConfig.get().getUuid() == null) {
                crdaUuid = UUID.randomUUID().toString();
                globalConfig.setUuid(crdaUuid);
            } else {
                crdaUuid = RHDAGlobalConfig.get().getUuid();
            }
            System.setProperty("RHDA-TOKEN", crdaUuid);
            System.setProperty("RHDA_SOURCE", "jenkins-plugin");
            System.setProperty("hudson.model.DirectoryBrowserSupport.CSP", "");
            System.setProperty("CONSENT_TELEMETRY", String.valueOf(this.step.getConsentTelemetry()));
            Path manifestPath = Paths.get(this.step.getFile(), new String[0]);
            if (manifestPath.getParent() == null) {
                manifestPath = Paths.get(workspace.child(this.step.getFile()).toURI());
            }
            if (!Files.exists(manifestPath, new LinkOption[0])) {
                logger.println("The specified file or path does not exist or is inaccessible. Please configure the build properly and retry.");
                return "1";
            }
            ExhortApi exhortApi = new ExhortApi();
            CompletableFuture mixedStackReport = exhortApi.stackAnalysisMixed(manifestPath.toString());
            try {
                this.processReport(((Api.MixedReport)mixedStackReport.get()).json, listener);
                this.saveHtmlReport(((Api.MixedReport)mixedStackReport.get()).html, listener, workspace);
                ArtifactArchiver archiver = new ArtifactArchiver("dependency-analytics-report.html");
                archiver.perform(run, workspace, (EnvVars)this.getContext().get(EnvVars.class), (Launcher)this.getContext().get(Launcher.class), listener);
                logger.println("Click on the RHDA Stack Report icon to view the detailed report.");
                logger.println("----- RHDA Analysis Ends -----");
                run.addAction((Action)new CRDAAction(crdaUuid, ((Api.MixedReport)mixedStackReport.get()).json, String.valueOf(workspace) + "/dependency-analysis-report.html", "pipeline"));
                return ((Api.MixedReport)mixedStackReport.get()).json.getSummary().getVulnerabilities().getTotal() == 0 ? "0" : "2";
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            return "2";
        }

        private void processReport(AnalysisReport report, TaskListener listener) throws ExecutionException, InterruptedException {
            PrintStream logger = listener.getLogger();
            DependenciesSummary dependenciesSummary = report.getSummary().getDependencies();
            VulnerabilitiesSummary vulnerabilitiesSummary = report.getSummary().getVulnerabilities();
            for (ProviderStatus providerStatus : report.getSummary().getProviderStatuses()) {
                if (providerStatus.getStatus() == 200) continue;
                logger.println("WARNING: " + providerStatus.getProvider() + ": " + providerStatus.getMessage());
            }
            logger.println("Summary");
            logger.println("  Dependencies");
            logger.println("    Scanned dependencies:    " + dependenciesSummary.getScanned());
            logger.println("    Transitive dependencies: " + dependenciesSummary.getTransitive());
            logger.println("  Vulnerabilities");
            logger.println("    Total: " + vulnerabilitiesSummary.getTotal());
            logger.println("    Direct: " + vulnerabilitiesSummary.getDirect());
            logger.println("    Critical: " + vulnerabilitiesSummary.getCritical());
            logger.println("    High: " + vulnerabilitiesSummary.getHigh());
            logger.println("    Medium: " + vulnerabilitiesSummary.getMedium());
            logger.println("    Low: " + vulnerabilitiesSummary.getLow());
            logger.println("");
        }

        private void saveHtmlReport(byte[] html, TaskListener listener, FilePath workspace) throws Exception {
            PrintStream logger = listener.getLogger();
            File file = new File(String.valueOf(workspace) + "/dependency-analytics-report.html");
            FileUtils.writeByteArrayToFile((File)file, (byte[])html);
            logger.println("You can find the latest detailed HTML report in your workspace and in your build under Build Artifacts.");
        }
    }
}

