/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.prism;

import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.VisibleForTesting;
import hudson.Extension;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.prism.PermittedSourceCodeDirectory;
import io.jenkins.plugins.prism.PrismTheme;
import io.jenkins.plugins.util.GlobalConfigurationFacade;
import io.jenkins.plugins.util.GlobalConfigurationItem;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"prismConfiguration"})
public class PrismConfiguration
extends GlobalConfigurationItem {
    private static final PathUtil PATH_UTIL = new PathUtil();
    private List<PermittedSourceCodeDirectory> sourceDirectories = Collections.emptyList();
    private Set<String> normalizedSourceDirectories = Collections.emptySet();
    private PrismTheme theme = PrismTheme.PRISM;
    private final JenkinsFacade jenkins;

    public PrismConfiguration() {
        this.jenkins = new JenkinsFacade();
        this.load();
    }

    @VisibleForTesting
    PrismConfiguration(GlobalConfigurationFacade facade, JenkinsFacade jenkins) {
        super(facade);
        this.jenkins = jenkins;
        this.load();
    }

    protected void clearRepeatableProperties() {
        this.setSourceDirectories(new ArrayList<PermittedSourceCodeDirectory>());
    }

    public static PrismConfiguration getInstance() {
        return (PrismConfiguration)((Object)GlobalConfiguration.all().get(PrismConfiguration.class));
    }

    public List<PermittedSourceCodeDirectory> getSourceDirectories() {
        return this.sourceDirectories;
    }

    @DataBoundSetter
    public void setSourceDirectories(List<PermittedSourceCodeDirectory> sourceDirectories) {
        this.sourceDirectories = new ArrayList<PermittedSourceCodeDirectory>(sourceDirectories);
        this.normalizedSourceDirectories = sourceDirectories.stream().map(PermittedSourceCodeDirectory::getPath).map(arg_0 -> ((PathUtil)PATH_UTIL).getAbsolutePath(arg_0)).collect(Collectors.toSet());
        this.save();
    }

    public boolean isAllowedSourceDirectory(String sourceDirectory) {
        return this.normalizedSourceDirectories.contains(PATH_UTIL.getAbsolutePath(sourceDirectory));
    }

    @DataBoundSetter
    public void setTheme(PrismTheme theme) {
        this.theme = theme;
    }

    public PrismTheme getTheme() {
        return this.theme;
    }

    @POST
    public ListBoxModel doFillThemeItems() {
        ListBoxModel options = new ListBoxModel();
        if (this.jenkins.hasPermission(Jenkins.ADMINISTER)) {
            options.addAll((Collection)PrismTheme.getAllDisplayNames());
        }
        return options;
    }
}

