/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.prism;

import hudson.model.ModelObject;
import hudson.model.Run;
import io.jenkins.plugins.prism.Marker;
import io.jenkins.plugins.prism.PrismConfiguration;
import io.jenkins.plugins.prism.SourcePrinter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class SourceCodeViewModel
implements ModelObject {
    private final Run<?, ?> owner;
    private final String fileName;
    private final String sourceCode;

    public SourceCodeViewModel(Run<?, ?> owner, String fileName, Reader sourceCodeReader, Marker marker) {
        this.owner = owner;
        this.fileName = fileName;
        this.sourceCode = this.render(sourceCodeReader, marker);
    }

    private String render(Reader affectedFile, Marker marker) {
        String string;
        BufferedReader reader = new BufferedReader(affectedFile);
        try {
            SourcePrinter sourcePrinter = new SourcePrinter();
            string = sourcePrinter.render(this.fileName, reader.lines(), marker);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return String.format("%s%n%s", ExceptionUtils.getMessage((Throwable)e), ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        reader.close();
        return string;
    }

    public String getDisplayName() {
        return this.fileName;
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public String getThemeCssFileName() {
        return PrismConfiguration.getInstance().getTheme().getFileName();
    }
}

