/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Action;
import hudson.model.Run;
import io.jenkins.plugins.util.AbstractXmlStream;
import io.jenkins.plugins.util.JobAction;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;

public abstract class BuildAction<T>
implements SimpleBuildStep.LastBuildAction,
RunAction2,
Serializable {
    private static final long serialVersionUID = -2074456133028895573L;
    private transient Run<?, ?> owner;
    private transient ReentrantLock lock = new ReentrantLock();
    @CheckForNull
    private transient WeakReference<T> resultReference;

    protected BuildAction(Run<?, ?> owner, T result) {
        this(owner, result, true);
    }

    @SuppressFBWarnings(value={"MC"}, justification="getResultXmlPath() is a factory method and overridable by design")
    @VisibleForTesting
    public BuildAction(Run<?, ?> owner, T result, boolean canSerialize) {
        this.owner = owner;
        this.resultReference = new WeakReference<T>(result);
        if (canSerialize) {
            this.createXmlStream().write(this.getResultXmlPath(), result);
        }
    }

    protected abstract AbstractXmlStream<T> createXmlStream();

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public void onAttached(Run<?, ?> r) {
        this.owner = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.onAttached(r);
    }

    protected Object readResolve() {
        this.lock = new ReentrantLock();
        return this;
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(this.createProjectAction());
    }

    protected abstract JobAction<? extends BuildAction<T>> createProjectAction();

    public T getResult() {
        this.lock.lock();
        try {
            if (this.resultReference == null) {
                T t = this.readResult();
                return t;
            }
            Object result = this.resultReference.get();
            if (result == null) {
                T t = this.readResult();
                return t;
            }
            Object t = result;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    private T readResult() {
        T statistics = this.createXmlStream().read(this.getResultXmlPath());
        this.resultReference = new WeakReference<T>(statistics);
        return statistics;
    }

    private Path getResultXmlPath() {
        return this.owner.getRootDir().toPath().resolve(this.getBuildResultBaseName());
    }

    protected abstract String getBuildResultBaseName();

    public static <T extends BuildAction<?>> Optional<T> getBuildActionFromHistoryStartingFrom(@CheckForNull Run<?, ?> baseline, Class<T> buildActionClass) {
        for (Run run = baseline; run != null; run = run.getPreviousBuild()) {
            BuildAction action = (BuildAction)run.getAction(buildActionClass);
            if (action == null) continue;
            return Optional.of(action);
        }
        return Optional.empty();
    }
}

