/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.CodeUnitsShouldConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenCodeUnitsConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenMethodsConjunction;
import com.tngtech.archunit.lang.syntax.elements.MethodsShouldConjunction;
import hudson.model.Descriptor;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.verb.POST;

public final class PluginArchitectureRules {
    public static final ArchRule NO_FORBIDDEN_PACKAGE_ACCESSED = ArchRuleDefinition.noClasses().should().dependOnClassesThat(JavaClass.Predicates.resideInAnyPackage((String[])new String[]{"org.apache.commons.lang..", "org.joda.time..", "javax.xml.bind..", "net.jcip.annotations..", "javax.annotation..", "junit..", "org.hamcrest..", "com.google.common..", "org.junit"}));
    public static final ArchRule NO_JENKINS_INSTANCE_CALL = ((GivenClassesConjunction)ArchRuleDefinition.noClasses().that().doNotHaveSimpleName("JenkinsFacade")).should().callMethod(Jenkins.class, "getInstance", new Class[0]).orShould().callMethod(Jenkins.class, "getInstanceOrNull", new Class[0]).orShould().callMethod(Jenkins.class, "getActiveInstance", new Class[0]).orShould().callMethod(Jenkins.class, "get", new Class[0]);
    public static final ArchRule AJAX_PROXY_METHOD_MUST_BE_IN_PUBLIC_CLASS = ((MethodsShouldConjunction)((MethodsShouldConjunction)((GivenMethodsConjunction)ArchRuleDefinition.methods().that().areAnnotatedWith(JavaScriptMethod.class)).should().bePublic()).andShould().beDeclaredInClassesThat().arePublic()).allowEmptyShould(true);
    public static final ArchRule DATA_BOUND_CONSTRUCTOR_MUST_BE_IN_PUBLIC_CLASS = ((CodeUnitsShouldConjunction)((GivenCodeUnitsConjunction)ArchRuleDefinition.constructors().that().areAnnotatedWith(DataBoundConstructor.class)).should().beDeclaredInClassesThat().arePublic()).allowEmptyShould(true);
    public static final ArchRule DATA_BOUND_SETTER_MUST_BE_IN_PUBLIC_CLASS = ((MethodsShouldConjunction)((GivenMethodsConjunction)ArchRuleDefinition.methods().that().areAnnotatedWith(DataBoundSetter.class)).should().beDeclaredInClassesThat().arePublic()).allowEmptyShould(true);
    public static final ArchRule USE_POST_FOR_VALIDATION_END_POINTS = ((MethodsShouldConjunction)((MethodsShouldConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)ArchRuleDefinition.methods().that().areDeclaredInClassesThat().areAssignableTo(Descriptor.class)).and().haveNameMatching("doCheck[A-Z].*")).and().haveRawReturnType(FormValidation.class)).should().beAnnotatedWith(POST.class)).andShould().bePublic()).andShould((ArchCondition)PluginArchitectureRules.checkPermissions()).allowEmptyShould(true);
    public static final ArchRule USE_POST_FOR_LIST_AND_COMBOBOX_FILL = ((MethodsShouldConjunction)((MethodsShouldConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)ArchRuleDefinition.methods().that().areDeclaredInClassesThat().areAssignableTo(Descriptor.class)).and().haveNameMatching("doFill[A-Z].*")).and().haveRawReturnType(PluginArchitectureRules.ofAllowedClasses(ComboBoxModel.class, ListBoxModel.class))).should().beAnnotatedWith(POST.class)).andShould().bePublic()).andShould((ArchCondition)PluginArchitectureRules.checkPermissions()).allowEmptyShould(true);

    private static HavePermissionCheck checkPermissions() {
        return new HavePermissionCheck();
    }

    private static DescribedPredicate<JavaClass> ofAllowedClasses(Class<?> ... classes) {
        return new AllowedClasses(classes);
    }

    private PluginArchitectureRules() {
    }

    private static class HavePermissionCheck
    extends ArchCondition<JavaMethod> {
        HavePermissionCheck() {
            super("should have a permission check", new Object[0]);
        }

        public void check(JavaMethod item, ConditionEvents events) {
            if (item.getModifiers().contains(JavaModifier.SYNTHETIC)) {
                return;
            }
            if (item.getCallsFromSelf().stream().anyMatch(javaCall -> ((AccessTarget.CodeUnitCallTarget)javaCall.getTarget()).getOwner().getFullName().equals(JenkinsFacade.class.getName()) && "hasPermission".equals(((AccessTarget.CodeUnitCallTarget)javaCall.getTarget()).getName()))) {
                return;
            }
            events.add(SimpleConditionEvent.violated((Object)item, (String)String.format("JenkinsFacade.hasPermission() not called in %s in %s", item.getDescription(), item.getSourceCodeLocation())));
        }
    }

    private static class AllowedClasses
    extends DescribedPredicate<JavaClass> {
        private final List<String> allowedClassNames;

        AllowedClasses(Class<?> ... classes) {
            super("raw return type of any of %s", new Object[]{Arrays.toString(classes)});
            this.allowedClassNames = Arrays.stream(classes).map(Class::getName).collect(Collectors.toList());
        }

        public boolean test(JavaClass input) {
            return this.allowedClassNames.contains(input.getFullName());
        }
    }
}

