/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import io.jenkins.plugins.util.Messages;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CharsetValidation {
    private static final Set<String> ALL_CHARSETS = Charset.availableCharsets().keySet();

    public ComboBoxModel getAllCharsets() {
        return new ComboBoxModel(ALL_CHARSETS);
    }

    public Charset getCharset(@CheckForNull String charset) {
        try {
            if (StringUtils.isNotBlank((CharSequence)charset)) {
                return Charset.forName(charset);
            }
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            // empty catch block
        }
        return Charset.defaultCharset();
    }

    public FormValidation validateCharset(String reportEncoding) {
        try {
            if (StringUtils.isBlank((CharSequence)reportEncoding) || Charset.isSupported(reportEncoding)) {
                return FormValidation.ok();
            }
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            // empty catch block
        }
        return FormValidation.errorWithMarkup((String)CharsetValidation.createWrongEncodingErrorMessage());
    }

    @VisibleForTesting
    static String createWrongEncodingErrorMessage() {
        return Messages.FieldValidator_Error_DefaultEncoding("https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html");
    }
}

