// CHECKSTYLE:OFF

package io.jenkins.plugins.util;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code FieldValidator.Error.DefaultEncoding}: {@code Encoding must
     * be a supported encoding of the Java platform, see: <a rel="noopener
     * noreferrer" href="{0}">java.nio.charset.Charset</a>}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Encoding must be a supported encoding of the Java platform,
     *     see: <a rel="noopener noreferrer"
     *     href="{0}">java.nio.charset.Charset</a>}
     */
    public static String FieldValidator_Error_DefaultEncoding(Object arg0) {
        return holder.format("FieldValidator.Error.DefaultEncoding", arg0);
    }

    /**
     * Key {@code FieldValidator.Error.DefaultEncoding}: {@code Encoding must
     * be a supported encoding of the Java platform, see: <a rel="noopener
     * noreferrer" href="{0}">java.nio.charset.Charset</a>}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Encoding must be a supported encoding of the Java platform,
     *     see: <a rel="noopener noreferrer"
     *     href="{0}">java.nio.charset.Charset</a>}
     */
    public static Localizable _FieldValidator_Error_DefaultEncoding(Object arg0) {
        return new Localizable(holder, "FieldValidator.Error.DefaultEncoding", arg0);
    }

}
