/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import hudson.DescriptorExtensionList;
import hudson.model.BallColor;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.security.Permission;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.acegisecurity.AccessDeniedException;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.Stapler;

public class JenkinsFacade
implements Serializable {
    private static final long serialVersionUID = 1904631270145841113L;

    public <T> List<T> getExtensionsFor(Class<T> extensionType) {
        return this.getJenkins().getExtensionList(extensionType);
    }

    public <T extends Describable<T>, D extends Descriptor<T>> DescriptorExtensionList<T, D> getDescriptorsFor(Class<T> describableType) {
        return this.getJenkins().getDescriptorList(describableType);
    }

    public boolean hasPermission(Permission permission) {
        return this.getJenkins().getACL().hasPermission(permission);
    }

    public Optional<Job<?, ?>> getJob(String name) {
        try {
            return Optional.ofNullable(this.getJenkins().getItemByFullName(name, Job.class));
        }
        catch (AccessDeniedException ignore) {
            return Optional.empty();
        }
    }

    public Optional<Run<?, ?>> getBuild(String id) {
        try {
            return Optional.ofNullable(Run.fromExternalizableId((String)id));
        }
        catch (AccessDeniedException accessDeniedException) {
            return Optional.empty();
        }
    }

    public String getImagePath(BallColor color) {
        return color.getImageOf("16x16");
    }

    public String getImagePath(String icon) {
        return Stapler.getCurrentRequest().getContextPath() + Jenkins.RESOURCE_PATH + icon;
    }

    public String getAbsoluteUrl(String ... urlElements) {
        return this.getAbsoluteUrl(StringUtils.join((Object[])urlElements, (String)"/"));
    }

    private String getAbsoluteUrl(String url) {
        try {
            String rootUrl = this.getJenkins().getRootUrl();
            if (rootUrl != null) {
                return rootUrl + "/" + url;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return url;
    }

    public Set<String> getAllJobNames() {
        return this.getAllJobs().stream().map(this::getFullNameOf).collect(Collectors.toSet());
    }

    public List<Job> getAllJobs() {
        return this.getJenkins().getAllItems(Job.class);
    }

    public String getFullNameOf(Job<?, ?> job) {
        return job.getFullName();
    }

    public boolean isPluginInstalled(String pluginId) {
        return this.getJenkins().getPlugin(pluginId) != null;
    }

    private Jenkins getJenkins() {
        return Jenkins.get();
    }
}

