/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import com.google.errorprone.annotations.FormatMethod;
import java.io.PrintStream;
import java.util.Collection;

class PrefixLogger {
    private final String toolName;
    private final PrintStream delegate;

    PrefixLogger(PrintStream logger, String toolName) {
        this.toolName = toolName.contains("[") ? toolName + " " : String.format("[%s] ", toolName);
        this.delegate = logger;
    }

    @FormatMethod
    void log(String format, Object ... args) {
        this.print(String.format(format, args));
    }

    void logEachLine(Collection<String> lines) {
        lines.forEach(this::print);
    }

    private void print(String line) {
        this.delegate.println(this.toolName + line);
    }
}

