/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.restful.api;

import com.cloudbees.workflow.rest.AbstractWorkflowJobActionHandler;
import com.cloudbees.workflow.util.ModelUtil;
import com.cloudbees.workflow.util.ServeJson;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Action;
import hudson.model.BuildAuthorizationToken;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import io.jenkins.plugins.pipeline.restful.api.Pipeline;
import io.jenkins.plugins.pipeline.restful.api.PipelineConvert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.util.TimeDuration;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.export.Flavor;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Restricted(value={NoExternalUse.class})
public class PipelineRestfulAPI
extends AbstractWorkflowJobActionHandler {
    public static final String URL_BASE = "restFul";

    public static String getUrl(WorkflowJob job) {
        return ModelUtil.getFullItemUrl((String)job.getUrl()) + URL_BASE;
    }

    public String getUrlName() {
        return URL_BASE;
    }

    @ServeJson
    public Pipeline doIndex() {
        Jenkins.get().checkPermission(Item.CONFIGURE);
        WorkflowJob job = this.getJob();
        FlowDefinition jobDef = job.getDefinition();
        ExtensionList extensionList = Jenkins.get().getExtensionList(PipelineConvert.class);
        for (PipelineConvert convert : extensionList) {
            if (!convert.accept(jobDef)) continue;
            return convert.convert(jobDef);
        }
        return null;
    }

    @RequirePOST
    public HttpResponse doUpdate(@QueryParameter String script) throws IOException {
        Jenkins.get().checkPermission(Item.CONFIGURE);
        WorkflowJob job = this.getJob();
        job.setDefinition((FlowDefinition)new CpsFlowDefinition(script, true));
        job.save();
        return hudson.util.HttpResponses.ok();
    }

    @RequirePOST
    public void doBuild(StaplerRequest req, StaplerResponse rsp, @QueryParameter TimeDuration delay) throws IOException, ServletException, InterruptedException {
        Jenkins.get().checkPermission(Item.BUILD);
        WorkflowJob job = this.getJob();
        if (delay == null) {
            delay = new TimeDuration(TimeUnit.MILLISECONDS.convert(job.getQuietPeriod(), TimeUnit.SECONDS));
        }
        if (!job.isBuildable()) {
            throw HttpResponses.error((int)409, (Throwable)new IOException(job.getFullName() + " is not buildable"));
        }
        IdentityBuild identityBuild = new IdentityBuild();
        String identifyCause = req.getParameter("identifyCause");
        String uuid = UUID.randomUUID().toString();
        IdentifyCause cause = new IdentifyCause(uuid, identifyCause);
        identityBuild.setCause(cause);
        ParametersDefinitionProperty pp = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
        if (pp != null) {
            this._doBuild(req, rsp, pp, cause, delay);
        } else {
            Jenkins.get().getQueue().schedule2((Queue.Task)job, delay.getTimeInSeconds(), new Action[]{PipelineRestfulAPI.getBuildCause((ParameterizedJobMixIn.ParameterizedJob)job, req), new CauseAction((Cause)cause)}).getItem();
        }
        long timeout = delay.as(TimeUnit.SECONDS);
        String expectedTimeout = req.getParameter("timeout");
        try {
            timeout += (long)Integer.parseInt(expectedTimeout);
        }
        catch (NumberFormatException e) {
            timeout += 100L;
        }
        int i = 0;
        while ((long)i < timeout) {
            WorkflowRun run = this.findBuild(job, uuid);
            if (run != null) {
                identityBuild.setBuild(run);
                break;
            }
            Thread.sleep(1000L);
            ++i;
        }
        rsp.serveExposedBean(req, (Object)identityBuild, req.getParameter("jsonp") == null ? Flavor.JSON : Flavor.JSONP);
    }

    public WorkflowRun findBuild(WorkflowJob job, String uuid) {
        return job.getNewBuilds().stream().filter(build -> {
            if (build == null) {
                return false;
            }
            return build.getActions(CauseAction.class).stream().anyMatch(action -> action.getCauses().stream().anyMatch(cause -> cause instanceof IdentifyCause && ((IdentifyCause)((Object)((Object)((Object)cause)))).uuid.equals(uuid)));
        }).findFirst().orElse(null);
    }

    public Queue.WaitingItem _doBuild(StaplerRequest req, StaplerResponse rsp, ParametersDefinitionProperty pp, Cause cause, @QueryParameter TimeDuration delay) throws IOException, ServletException {
        if (delay == null) {
            delay = new TimeDuration(TimeUnit.MILLISECONDS.convert(this.getJob().getQuietPeriod(), TimeUnit.SECONDS));
        }
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        JSONObject formData = req.getSubmittedForm();
        JSONArray a = JSONArray.fromObject((Object)formData.get("parameter"));
        for (Object o : a) {
            JSONObject jo = (JSONObject)o;
            String name = jo.getString("name");
            ParameterDefinition d = this.getParameterDefinition(pp, name);
            if (d == null) {
                throw new IllegalArgumentException("No such parameter definition: " + name);
            }
            ParameterValue parameterValue = d.createValue(req, jo);
            if (parameterValue != null) {
                values.add(parameterValue);
                continue;
            }
            throw new IllegalArgumentException("Cannot retrieve the parameter value: " + name);
        }
        Queue.WaitingItem item = Jenkins.get().getQueue().schedule((Queue.Task)this.getJob(), delay.getTimeInSeconds(), new Action[]{new ParametersAction(values), new CauseAction((Cause)new Cause.UserIdCause()), new CauseAction(cause)});
        return item;
    }

    @CheckForNull
    public ParameterDefinition getParameterDefinition(ParametersDefinitionProperty pp, String name) {
        for (ParameterDefinition pd : pp.getParameterDefinitions()) {
            if (!pd.getName().equals(name)) continue;
            return pd;
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public static CauseAction getBuildCause(ParameterizedJobMixIn.ParameterizedJob job, StaplerRequest req) {
        Cause.UserIdCause cause;
        BuildAuthorizationToken authToken = job.getAuthToken();
        if (authToken != null && authToken.getToken() != null && req.getParameter("token") != null) {
            String causeText = req.getParameter("cause");
            cause = new Cause.RemoteCause(req.getRemoteAddr(), causeText);
        } else {
            cause = new Cause.UserIdCause();
        }
        return new CauseAction((Cause)cause);
    }

    @ExportedBean
    class IdentifyCause
    extends Cause {
        private String uuid;
        private String message;

        public IdentifyCause(String uuid, String message) {
            this.uuid = uuid;
            this.message = message;
        }

        @Exported
        public String getUuid() {
            return this.uuid;
        }

        @Exported
        public String getMessage() {
            return this.message;
        }

        public String getShortDescription() {
            String desc = String.format("Identity cause, message is %s, uuid is %s", this.message, this.uuid);
            try {
                return Jenkins.get().getMarkupFormatter().translate(desc);
            }
            catch (IOException e) {
                e.printStackTrace();
                return desc;
            }
        }
    }

    @ExportedBean
    class IdentityBuild {
        private WorkflowRun build;
        private IdentifyCause cause;

        IdentityBuild() {
        }

        @Exported
        public WorkflowRun getBuild() {
            return this.build;
        }

        @Exported
        public IdentifyCause getCause() {
            return this.cause;
        }

        public void setBuild(WorkflowRun build) {
            this.build = build;
        }

        public void setCause(IdentifyCause cause) {
            this.cause = cause;
        }
    }
}

