/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.restful.api;

import com.cloudbees.workflow.util.ServeJson;
import hudson.Extension;
import hudson.model.RootAction;
import io.jenkins.plugins.pipeline.restful.api.SimpleItem;
import io.jenkins.plugins.pipeline.restful.api.SimpleItemUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;

@Extension
@Restricted(value={NoExternalUse.class})
public class ItemAPI
implements RootAction {
    public static final String URL_BASE = "items";

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        return "Item API";
    }

    public String getUrlName() {
        return URL_BASE;
    }

    @ServeJson
    public List<SimpleItem> doList(@QueryParameter String name, @QueryParameter String type, @QueryParameter String parent, @QueryParameter int start, @QueryParameter int limit) {
        List items = Jenkins.get().getAllItems();
        ArrayList<SimpleItem> simpleItems = new ArrayList<SimpleItem>();
        boolean filterName = StringUtils.isNotEmpty((String)name);
        boolean filterType = StringUtils.isNotEmpty((String)type);
        start = start < 0 ? 0 : start;
        limit = limit <= 0 ? 50 : limit;
        items.stream().filter(item -> !filterName || item.getName().contains(name)).filter(item -> !filterType || item.getClass().getSimpleName().contains(type)).filter(item -> StringUtils.isBlank((String)parent) || item.getFullName().startsWith(parent)).skip(start).limit(limit).forEach(item -> simpleItems.add(SimpleItemUtils.convert(item)));
        return simpleItems;
    }
}

