/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.restful.api;

import com.cloudbees.workflow.util.ServeJson;
import hudson.Extension;
import hudson.model.RootAction;
import hudson.util.HttpResponses;
import io.jenkins.plugins.pipeline.restful.api.JenkinsInstance;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import jenkins.model.identity.IdentityRootAction;
import jenkins.slaves.JnlpSlaveAgentProtocol;
import org.acegisecurity.AccessDeniedException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Restricted(value={NoExternalUse.class})
public class InstanceAPI
implements RootAction {
    private static final Logger LOGGER = Logger.getLogger(InstanceAPI.class.getName());

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        return "Jenkins instance API";
    }

    @CheckForNull
    public String getUrlName() {
        return "instance";
    }

    @ServeJson
    public JenkinsInstance doIndex() {
        IdentityRootAction identityAction = new IdentityRootAction();
        JenkinsInstance jenkinsInstance = new JenkinsInstance(identityAction.getFingerprint(), identityAction.getPublicKey());
        jenkinsInstance.setSystemMessage(Jenkins.get().getSystemMessage());
        return jenkinsInstance;
    }

    @RequirePOST
    public HttpResponse doUpdateMessage(StaplerRequest req) {
        String message = req.getParameter("message");
        try {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            Jenkins.get().setSystemMessage(message);
        }
        catch (IOException | AccessDeniedException e) {
            LOGGER.log(Level.SEVERE, "cannot set system message of Jenkins", e);
            return HttpResponses.errorJSON((String)e.getMessage());
        }
        return HttpResponses.ok();
    }

    @RequirePOST
    public HttpResponse doAgentSecret(@QueryParameter String name) {
        try {
            return HttpResponses.text((String)JnlpSlaveAgentProtocol.SLAVE_SECRET.mac(name));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "cannot get the slave secret", e);
            return HttpResponses.errorJSON((String)e.getMessage());
        }
    }
}

