/*
 * Decompiled with CFR 0.152.
 */
package io.plugins.perfecto.credentials;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.Secret;
import io.plugins.perfecto.PerfectoBuildWrapper;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.net.ssl.HttpsURLConnection;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class PerfectoCredentials
extends BaseStandardCredentials
implements StandardUsernamePasswordCredentials {
    protected final String userName;
    protected final String cloudName;
    protected final Secret apiKey;
    private static final String ERR_EMPTY_AUTH = "Empty username or cloudname or security token!";
    private static final String ERR_INVALID_AUTH = "Invalid username or cloudname or security token!";
    private static final String OK_VALID_AUTH = "Success";
    protected ShortLivedConfig shortLivedConfig;
    private static final String HMAC_KEY = "HMACMD5";
    private static final String DATE_FORMAT = "yyyy-MM-dd-HH";

    @DataBoundConstructor
    public PerfectoCredentials(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String userName, @CheckForNull String cloudName, @NonNull String apiKey, @CheckForNull String description) {
        super(scope, id, description);
        this.userName = userName;
        this.cloudName = cloudName;
        this.apiKey = Secret.fromString((String)apiKey);
    }

    public ShortLivedConfig getShortLivedConfig() {
        return this.shortLivedConfig;
    }

    @DataBoundSetter
    public void setShortLivedConfig(ShortLivedConfig shortLivedConfig) {
        this.shortLivedConfig = shortLivedConfig;
    }

    public static PerfectoCredentials getCredentials(AbstractProject project) {
        if (project == null) {
            return null;
        }
        if (!(project instanceof BuildableItemWithBuildWrappers)) {
            return PerfectoCredentials.getCredentials((AbstractProject)project.getParent());
        }
        BuildableItemWithBuildWrappers p = (BuildableItemWithBuildWrappers)project;
        PerfectoBuildWrapper bw = (PerfectoBuildWrapper)p.getBuildWrappersList().get(PerfectoBuildWrapper.class);
        if (bw == null) {
            return null;
        }
        String credentialsId = bw.getCredentialId();
        return PerfectoCredentials.getCredentialsById((Item)p, credentialsId);
    }

    public static FormValidation testAuthentication(String username, String cloudName, String apikey) {
        String checkConnectionURL = "https://" + cloudName + ".perfectomobile.com/services/users/" + username + "?operation=info&securityToken=" + apikey;
        HttpURLConnection conn = null;
        try {
            URL myURL = new URL(checkConnectionURL);
            conn = (HttpsURLConnection)myURL.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Accept", "application/json");
            int response = conn.getResponseCode();
            System.out.println("response" + response);
            if (response != 200) {
                conn.disconnect();
                return FormValidation.error((String)("Invalid username or cloudname or security token!, HTTP error code : " + response));
            }
            conn.disconnect();
        }
        catch (Exception e) {
            if (conn != null) {
                conn.disconnect();
            }
            System.out.println("exception: " + e);
            return FormValidation.error((String)ERR_INVALID_AUTH);
        }
        System.out.println("success");
        return FormValidation.ok((String)OK_VALID_AUTH);
    }

    public static PerfectoCredentials getCredentials(AbstractBuild build) {
        return PerfectoCredentials.getCredentials(build.getProject());
    }

    @NonNull
    public Secret getPassword() {
        if (this.getShortLivedConfig() != null) {
            try {
                Date d = new Date();
                Date expires = new Date(System.currentTimeMillis() + (long)this.getShortLivedConfig().getTime().intValue() * 1000L * 60L);
                String token = JWT.create().withExpiresAt(expires).withIssuedAt(d).sign(Algorithm.HMAC256((String)this.apiKey.getPlainText()));
                return Secret.fromString((String)token);
            }
            catch (JWTCreationException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return this.getApiKey();
    }

    @NonNull
    public String getUserName() {
        return this.userName;
    }

    @NonNull
    public Secret getApiKey() {
        return this.apiKey;
    }

    public static PerfectoCredentials getPerfectoCredentials(AbstractBuild build, PerfectoBuildWrapper wrapper) {
        String credentialId = wrapper.getCredentialId();
        return PerfectoCredentials.getCredentialsById((Item)build.getProject(), credentialId);
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public static String migrateToCredentials(String username, String cloudName, String accessKey, String migratedFrom) throws InterruptedException, IOException {
        String credentialId;
        List<PerfectoCredentials> credentialsForDomain = PerfectoCredentials.all((Item)null);
        StandardUsernameCredentials existingCredentials = (StandardUsernameCredentials)CredentialsMatchers.firstOrNull(credentialsForDomain, (CredentialsMatcher)CredentialsMatchers.withUsername((String)username));
        if (existingCredentials == null) {
            String createdCredentialId = UUID.randomUUID().toString();
            if (Strings.isNullOrEmpty((String)accessKey)) {
                throw new InterruptedException("Did not find password");
            }
            PerfectoCredentials credentialsToCreate = new PerfectoCredentials(CredentialsScope.GLOBAL, createdCredentialId, username, cloudName, accessKey, "migrated from " + migratedFrom);
            SystemCredentialsProvider credentialsProvider = SystemCredentialsProvider.getInstance();
            Map credentialsMap = credentialsProvider.getDomainCredentialsMap();
            Domain domain = Domain.global();
            if (credentialsMap.get(domain) == null) {
                credentialsMap.put(domain, Collections.EMPTY_LIST);
            }
            ((List)credentialsMap.get(domain)).add(credentialsToCreate);
            credentialsProvider.setDomainCredentialsMap(credentialsMap);
            credentialsProvider.save();
            credentialId = createdCredentialId;
        } else {
            credentialId = existingCredentials.getId();
        }
        return credentialId;
    }

    public static List<PerfectoCredentials> all(ItemGroup context) {
        return CredentialsProvider.lookupCredentials(PerfectoCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM);
    }

    public static List<PerfectoCredentials> all(Item context) {
        return CredentialsProvider.lookupCredentials(PerfectoCredentials.class, (Item)context, (Authentication)ACL.SYSTEM);
    }

    public static PerfectoCredentials getCredentialsById(Item context, String id) {
        return (PerfectoCredentials)CredentialsMatchers.firstOrNull(PerfectoCredentials.all(context), (CredentialsMatcher)CredentialsMatchers.withId((String)id));
    }

    public String getUsername() {
        return "";
    }

    public static final class ShortLivedConfig
    extends AbstractDescribableImpl<ShortLivedConfig>
    implements Serializable {
        protected final Integer time;

        @DataBoundConstructor
        public ShortLivedConfig(Integer time) {
            this.time = time;
        }

        public Integer getTime() {
            return this.time;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<ShortLivedConfig> {
            public String getDisplayName() {
                return "";
            }
        }
    }

    @Extension(ordinal=1.0)
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        public String getDisplayName() {
            return "Perfecto";
        }

        public String getIconClassName() {
            return "icon-perfecto-credential";
        }

        @POST
        public final FormValidation doAuthenticate(@QueryParameter(value="userName") String userName, @QueryParameter(value="cloudName") String cloudName, @QueryParameter(value="apiKey") String apiKey) {
            if (StringUtils.isBlank((String)userName) || StringUtils.isBlank((String)cloudName) || StringUtils.isBlank((String)apiKey)) {
                return FormValidation.error((String)PerfectoCredentials.ERR_EMPTY_AUTH);
            }
            return PerfectoCredentials.testAuthentication(userName, cloudName, apiKey);
        }

        @POST
        public FormValidation doCheckCloudName(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)"Cloud Name cannot be empty");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckApiKey(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)"Security Token cannot be empty");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckUserName(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)"Username cannot be empty");
            }
            return FormValidation.ok();
        }
    }
}

