/*
 * Decompiled with CFR 0.152.
 */
package io.plugins.perfecto;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.listeners.ItemListener;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.plugins.perfecto.PerfectoEnvironmentUtil;
import io.plugins.perfecto.credentials.PerfectoCredentials;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class PerfectoBuildWrapper
extends BuildWrapper
implements Serializable {
    private static final Logger logger = Logger.getLogger(PerfectoBuildWrapper.class.getName());
    public static final String PERFECTO_SECURITY_TOKEN = "perfectoSecurityToken";
    public static final String PERFECTO_CLOUD_NAME = "perfectoCloudName";
    public static final Pattern ENVIRONMENT_VARIABLE_PATTERN = Pattern.compile("[$|%][{]?([a-zA-Z_][a-zA-Z0-9_]+)[}]?");
    private String tunnelIdCustomName = "tunnelId";
    private boolean enablePerfectoConnect;
    private String perfectoConnectLocation;
    private String perfectoSecurityToken;
    private String pcParameters;
    private String reuseTunnelId;
    private PerfectoCredentials credentials;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private RunCondition condition;
    private String credentialId;
    private String tunnelId;
    private String perfectoConnectFile;
    private String pcLocation = "";

    public void makeSensitiveBuildVariables(AbstractBuild build, Set<String> sensitiveVariables) {
        super.makeSensitiveBuildVariables(build, sensitiveVariables);
        sensitiveVariables.add(PERFECTO_SECURITY_TOKEN);
    }

    @DataBoundConstructor
    public PerfectoBuildWrapper(RunCondition condition, String credentialId, String tunnelIdCustomName, String pcParameters, String perfectoConnectLocation, String perfectoSecurityToken, String perfectoConnectFile, String reuseTunnelId) {
        this.perfectoConnectLocation = perfectoConnectLocation;
        this.condition = condition;
        if (tunnelIdCustomName.length() > 1) {
            this.tunnelIdCustomName = tunnelIdCustomName;
        }
        this.credentialId = credentialId;
        this.perfectoSecurityToken = perfectoSecurityToken;
        this.pcParameters = pcParameters;
        this.perfectoConnectFile = perfectoConnectFile;
        this.reuseTunnelId = reuseTunnelId;
    }

    private String getTunnelId(String perfectoConnectLocation, String cloudName, String apiKey, BuildListener listener) throws IOException {
        Process process;
        String[] cmdArgs;
        String tunnelId = null;
        boolean isWindows = Functions.isWindows();
        this.pcLocation = perfectoConnectLocation.endsWith("/") || perfectoConnectLocation.endsWith("\\") ? perfectoConnectLocation + this.perfectoConnectFile : perfectoConnectLocation + File.separator + this.perfectoConnectFile;
        String baseCommand = this.pcLocation.trim() + " start -c " + cloudName.trim() + ".perfectomobile.com -s " + apiKey.trim();
        listener.getLogger().println(this.pcLocation.trim() + " start -c " + cloudName.trim() + ".perfectomobile.com -s <<TOKEN>> " + this.pcParameters.trim());
        if (isWindows) {
            cmdArgs = new String[]{"cmd.exe", "/c", baseCommand + " " + this.pcParameters.trim()};
            process = new ProcessBuilder(cmdArgs).redirectErrorStream(true).start();
        } else {
            cmdArgs = new String[]{"bash", "-c", "(cd " + perfectoConnectLocation + "; " + baseCommand + " " + this.pcParameters.trim() + ")"};
            process = Runtime.getRuntime().exec(cmdArgs);
        }
        InputStream is = process.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        String s = null;
        while ((s = reader.readLine()) != null) {
            listener.getLogger().println(s);
            Matcher m = Pattern.compile("^[A-Za-z0-9-]+$").matcher(s);
            if (m.find()) {
                tunnelId = m.group(0);
                listener.getLogger().println("Tunnel Id : " + tunnelId);
            }
            if (s.contains("bash: ")) {
                listener.fatalError("Perfecto Connect Path and Name is not Correct. Path Provided : '" + this.pcLocation + "'");
                throw new IOException("Perfecto Connect Path and Name is not Correct. Path Provided : '" + this.pcLocation + "'");
            }
            if (!s.contains("Can't start Perfecto Connect") && !s.contains("failed to start")) continue;
            listener.fatalError(tunnelId);
            throw new IOException(tunnelId);
        }
        reader.close();
        if (tunnelId == null) {
            listener.fatalError("Unable to create tunnel ID. Kindly cross check your parameters or raise a Perfecto support case.");
            throw new IOException("Unable to create tunnel ID. Kindly cross check your parameters or raise a Perfecto support case.");
        }
        return tunnelId;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Creating Tunnel Id........!");
        logger.fine("Setting Perfecto Build Wrapper");
        this.credentials = PerfectoCredentials.getPerfectoCredentials(build, this);
        CredentialsProvider.track((Run)build, (Credentials)this.credentials);
        if (this.credentials == null && !this.reuseTunnelId.contains("-")) {
            listener.fatalError("Credentials missing......");
            throw new IOException("Credentials missing......");
        }
        if (!this.reuseTunnelId.contains("-")) {
            String apiKey = this.credentials.getPassword().getPlainText();
            this.tunnelId = this.getTunnelId(this.perfectoConnectLocation, this.credentials.getCloudName(), apiKey, listener);
        } else {
            this.tunnelId = this.reuseTunnelId;
        }
        listener.getLogger().println("Tunnel Id created succesfully.");
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                logger.fine("Creating Perfecto environment variables");
                PerfectoEnvironmentUtil.outputEnvironmentVariable(env, PerfectoBuildWrapper.this.tunnelIdCustomName, PerfectoBuildWrapper.this.tunnelId, true);
            }

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                return true;
            }
        };
    }

    public boolean isEnablePerfectoConnect() {
        return this.enablePerfectoConnect;
    }

    public void setEnablePerfectoConnect(boolean enablePerfectoConnect) {
        this.enablePerfectoConnect = enablePerfectoConnect;
    }

    public String getTunnelIdCustomName() {
        return this.tunnelIdCustomName;
    }

    public void setTunnelIdCustomName(String tunnelIdCustomName) {
        this.tunnelIdCustomName = tunnelIdCustomName;
    }

    public String getPerfectoConnectFile() {
        return this.perfectoConnectFile;
    }

    public void setPerfectoConnectFile(String perfectoConnectFile) {
        this.perfectoConnectFile = perfectoConnectFile;
    }

    public String getPerfectoConnectLocation() {
        return this.perfectoConnectLocation;
    }

    public void setPerfectoConnectLocation(String perfectoConnectLocation) {
        this.perfectoConnectLocation = perfectoConnectLocation;
    }

    public String getSecurityToken() {
        return this.perfectoSecurityToken;
    }

    public void setSecurityToken(String perfectoSecurityToken) {
        this.perfectoSecurityToken = perfectoSecurityToken;
    }

    public RunCondition getCondition() {
        return this.condition;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    public String getPcParameters() {
        return this.pcParameters;
    }

    public void setPcParameters(String pcParameters) {
        this.pcParameters = pcParameters;
    }

    protected boolean migrateCredentials(AbstractProject project) {
        if (Strings.isNullOrEmpty((String)this.credentialId)) {
            if (this.credentials != null) {
                try {
                    this.credentialId = PerfectoCredentials.migrateToCredentials(this.credentials.getUsername(), this.credentials.getCloudName(), this.credentials.getApiKey().getPlainText(), project == null ? "Unknown" : project.getDisplayName());
                    return true;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                if (this.credentials != null) {
                    this.credentialId = PerfectoCredentials.migrateToCredentials(this.credentials.getUsername(), this.credentials.getCloudName(), this.credentials.getApiKey().getPlainText(), "Global");
                    return true;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Extension
    public static final class ItemListenerImpl
    extends ItemListener {
        public void onLoaded() {
            Jenkins instance = Jenkins.getInstance();
            if (instance == null) {
                return;
            }
            for (BuildableItemWithBuildWrappers item : instance.getItems(BuildableItemWithBuildWrappers.class)) {
                AbstractProject p = item.asProject();
                for (PerfectoBuildWrapper bw : ((BuildableItemWithBuildWrappers)p).getBuildWrappersList().getAll(PerfectoBuildWrapper.class)) {
                    if (!bw.migrateCredentials(p)) continue;
                    try {
                        p.save();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Extension(ordinal=1.0)
    @Symbol(value={"withPerfecto"})
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return "Perfecto Connect";
        }

        @POST
        public ListBoxModel doFillCredentialIdItems(@AncestorInPath ItemGroup<?> context, @QueryParameter String credentialId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return null;
            }
            if (context == null || !jenkins.hasPermission(Jenkins.ADMINISTER)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(credentialId);
            }
            if (!((AccessControlled)context).hasPermission(Item.CONFIGURE)) {
                return new StandardUsernameListBoxModel();
            }
            return new StandardUsernameListBoxModel().includeAs(ACL.SYSTEM, context, PerfectoCredentials.class).includeCurrentValue(credentialId);
        }

        @POST
        public FormValidation doCheckCredentialId(@AncestorInPath Item item, @QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (item != null && !value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            if (value == null || value.isEmpty() || CredentialsProvider.listCredentials(PerfectoCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.withId((String)value)).isEmpty()) {
                return FormValidation.error((String)"Add/ Select a Perfecto kind credentials with valid Cloud Name, Username and Security Token.");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckPerfectoConnectLocation(@QueryParameter String value, @AncestorInPath Item item) {
            if (item == null) {
                return FormValidation.ok();
            }
            item.checkPermission(Item.CONFIGURE);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)"Perfecto connect location cannot be empty");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckPerfectoConnectFile(@QueryParameter String value, @AncestorInPath Item item) {
            if (item == null) {
                return FormValidation.ok();
            }
            item.checkPermission(Item.CONFIGURE);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)"Perfecto connect file name cannot be empty");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }
}

