/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.servlet;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.User;
import io.jenkins.plugins.opentelemetry.semconv.JenkinsOtelSemanticAttributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class OpenTelemetryServletFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(OpenTelemetryServletFilter.class.getName());
    private final Tracer tracer;

    public OpenTelemetryServletFilter(Tracer tracer) {
        this.tracer = tracer;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            this._doFilter((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _doFilter(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        SpanBuilder spanBuilder;
        Object httpRoute;
        String rootPath;
        String pathInfo = servletRequest.getPathInfo();
        List<Object> pathInfoTokens = Collections.list(new StringTokenizer(pathInfo, "/")).stream().map(token -> (String)token).filter(t -> !t.isEmpty()).collect(Collectors.toList());
        if (pathInfoTokens.isEmpty()) {
            pathInfoTokens = Collections.singletonList("");
        }
        if ((rootPath = (String)pathInfoTokens.get(0)).equals("static") || rootPath.equals("adjuncts") || rootPath.equals("scripts") || rootPath.equals("plugin") || rootPath.equals("images") || rootPath.equals("sse-gateway")) {
            filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            return;
        }
        if (rootPath.equals("$stapler")) {
            filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            return;
        }
        try {
            if (rootPath.equals("job")) {
                ParsedJobUrl parsedJobUrl = this.parseJobUrl(pathInfoTokens);
                httpRoute = parsedJobUrl.urlPattern;
                spanBuilder = this.tracer.spanBuilder(servletRequest.getMethod() + " " + parsedJobUrl.urlPattern);
                if (parsedJobUrl.jobName != null) {
                    spanBuilder.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_ID, (Object)parsedJobUrl.jobName);
                }
                if (parsedJobUrl.runNumber != null) {
                    spanBuilder.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_NUMBER, (Object)parsedJobUrl.runNumber);
                }
            } else if (rootPath.equals("blue")) {
                if (pathInfoTokens.size() == 1) {
                    httpRoute = "/blue/";
                    spanBuilder = this.tracer.spanBuilder(servletRequest.getMethod() + " " + (String)httpRoute);
                } else if ("rest".equals(pathInfoTokens.get(1))) {
                    if (pathInfoTokens.size() == 2) {
                        httpRoute = "/blue/rest/";
                        spanBuilder = this.tracer.spanBuilder(servletRequest.getMethod() + " " + (String)httpRoute);
                    } else if ("organizations".equals(pathInfoTokens.get(2)) && pathInfoTokens.size() > 7) {
                        ParsedJobUrl parsedBlueOceanPipelineUrl = this.parseBlueOceanRestPipelineUrl(pathInfoTokens);
                        httpRoute = parsedBlueOceanPipelineUrl.urlPattern;
                        spanBuilder = this.tracer.spanBuilder(servletRequest.getMethod() + " " + parsedBlueOceanPipelineUrl.urlPattern);
                        if (parsedBlueOceanPipelineUrl.jobName != null) {
                            spanBuilder.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_ID, (Object)parsedBlueOceanPipelineUrl.jobName);
                        }
                        if (parsedBlueOceanPipelineUrl.runNumber != null) {
                            spanBuilder.setAttribute(JenkinsOtelSemanticAttributes.CI_PIPELINE_RUN_NUMBER, (Object)parsedBlueOceanPipelineUrl.runNumber);
                        }
                    } else if ("classes".equals(pathInfoTokens.get(2)) && pathInfoTokens.size() > 3) {
                        String blueOceanClass = pathInfoTokens.get(3);
                        httpRoute = "/blue/rest/classes/:blueOceanClass";
                        spanBuilder = this.tracer.spanBuilder(servletRequest.getMethod() + " " + (String)httpRoute).setAttribute("blueOceanClass", blueOceanClass);
                    } else {
                        httpRoute = "/blue/rest/" + pathInfoTokens.get(2) + "/*";
                        spanBuilder = this.tracer.spanBuilder(servletRequest.getMethod() + " " + (String)httpRoute);
                    }
                } else {
                    httpRoute = "/blue/" + pathInfoTokens.get(1) + "/*";
                    spanBuilder = this.tracer.spanBuilder(servletRequest.getMethod() + " " + (String)httpRoute);
                }
            } else if (rootPath.equals("administrativeMonitor")) {
                httpRoute = "/administrativeMonitor/:administrativeMonitor/*";
                spanBuilder = this.tracer.spanBuilder(servletRequest.getMethod() + " /administrativeMonitor/");
                if (pathInfoTokens.size() > 1) {
                    spanBuilder.setAttribute("administrativeMonitor", pathInfoTokens.get(1));
                }
            } else if (rootPath.equals("asynchPeople")) {
                httpRoute = "/asynchPeople";
                spanBuilder = this.tracer.spanBuilder(servletRequest.getMethod() + " /asynchPeople");
            } else if (rootPath.equals("computer")) {
                httpRoute = "/computer/:computer/*";
                spanBuilder = this.tracer.spanBuilder(servletRequest.getMethod() + " /computer/*");
            } else if (rootPath.equals("credentials")) {
                httpRoute = "/credentials/store/:store/domain/:domain/*";
                spanBuilder = this.tracer.spanBuilder(servletRequest.getMethod() + " /credentials/*");
            } else if (rootPath.equals("descriptorByName")) {
                httpRoute = "/descriptorByName/:descriptor/*";
                spanBuilder = this.tracer.spanBuilder(servletRequest.getMethod() + " /descriptorByName/");
                if (pathInfoTokens.size() > 1) {
                    spanBuilder.setAttribute("descriptor", pathInfoTokens.get(1));
                }
            } else if (rootPath.equals("extensionList")) {
                httpRoute = "/extensionList/:extension/*";
                spanBuilder = this.tracer.spanBuilder(servletRequest.getMethod() + " /extensionList/");
                if (pathInfoTokens.size() > 1) {
                    spanBuilder.setAttribute("extension", pathInfoTokens.get(1));
                }
            } else if (rootPath.equals("fingerprint")) {
                httpRoute = "/fingerprint/:fingerprint";
                spanBuilder = this.tracer.spanBuilder(servletRequest.getMethod() + " /fingerprint/");
                spanBuilder.setAttribute("fingerprint", pathInfo.substring("/fingerprint/".length()));
                if (pathInfoTokens.size() > 1) {
                    spanBuilder.setAttribute("fingerprint", pathInfoTokens.get(1));
                }
            } else if (rootPath.equals("user")) {
                httpRoute = "/user/:user/*";
                spanBuilder = this.tracer.spanBuilder(servletRequest.getMethod() + " /user/*");
                if (pathInfoTokens.size() > 1) {
                    spanBuilder.setAttribute("user", pathInfoTokens.get(1));
                }
            } else {
                httpRoute = "/" + rootPath + "/*";
                spanBuilder = this.tracer.spanBuilder(servletRequest.getMethod() + " " + pathInfo);
            }
        }
        catch (RuntimeException e) {
            httpRoute = "/" + rootPath + "/*";
            spanBuilder = this.tracer.spanBuilder(servletRequest.getMethod() + " " + pathInfo);
            logger.log(Level.INFO, () -> "Exception processing URL " + pathInfo + ", default to httpRoute: '/" + rootPath + "/*': " + e);
        }
        Object httpTarget = servletRequest.getRequestURI();
        String queryString = servletRequest.getQueryString();
        if (queryString != null && !queryString.isEmpty()) {
            httpTarget = (String)httpTarget + "?" + queryString;
        }
        Thread currentThread = Thread.currentThread();
        spanBuilder.setAttribute(SemanticAttributes.HTTP_CLIENT_IP, (Object)servletRequest.getRemoteAddr()).setAttribute(SemanticAttributes.HTTP_SCHEME, (Object)servletRequest.getScheme()).setAttribute(SemanticAttributes.NET_HOST_NAME, (Object)servletRequest.getServerName()).setAttribute(SemanticAttributes.NET_HOST_NAME, (Object)(servletRequest.getServerName() + ":" + servletRequest.getServerPort())).setAttribute(SemanticAttributes.HTTP_METHOD, (Object)servletRequest.getMethod()).setAttribute(SemanticAttributes.HTTP_TARGET, httpTarget).setAttribute(SemanticAttributes.HTTP_ROUTE, httpRoute).setAttribute(SemanticAttributes.NET_TRANSPORT, (Object)"ip_tcp").setAttribute(SemanticAttributes.NET_SOCK_PEER_ADDR, (Object)servletRequest.getRemoteAddr()).setAttribute(SemanticAttributes.NET_SOCK_PEER_PORT, (Object)servletRequest.getRemotePort()).setAttribute(SemanticAttributes.THREAD_NAME, (Object)currentThread.getName()).setAttribute(SemanticAttributes.THREAD_ID, (Object)currentThread.getId()).setSpanKind(SpanKind.SERVER);
        User user = User.current();
        if (user != null) {
            spanBuilder.setAttribute(SemanticAttributes.ENDUSER_ID, (Object)user.getId());
        }
        Span span = spanBuilder.startSpan();
        try (Scope scope = span.makeCurrent();){
            filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, servletResponse.getStatus());
        }
        finally {
            span.end();
        }
    }

    void checkUrlPathInfoMatch(List<String> pathInfo, List<String> expected) {
        int violationIndex = this.getUrlPathInfoMatch(pathInfo, expected);
        if (violationIndex >= 0) {
            throw new IllegalArgumentException("Invalid URL path /" + String.join((CharSequence)"/", pathInfo) + ", expected: /" + String.join((CharSequence)"/", expected) + ". Violation on item " + violationIndex + ", expected: '" + expected.get(violationIndex) + "', actual: '" + (violationIndex < pathInfo.size() ? "<<missing>>" : pathInfo.get(violationIndex)) + "'");
        }
    }

    boolean isUrlPathInfoMatch(List<String> pathInfo, String ... expected) {
        return this.isUrlPathInfoMatch(pathInfo, Arrays.asList(expected));
    }

    boolean isUrlPathInfoMatch(List<String> pathInfo, List<String> expected) {
        int violationIndex = this.getUrlPathInfoMatch(pathInfo, expected);
        return violationIndex == -1;
    }

    private int getUrlPathInfoMatch(List<String> pathInfo, List<String> expected) {
        int violationIndex = -1;
        if (pathInfo.size() < expected.size()) {
            violationIndex = pathInfo.size() + 1;
        }
        for (int i = 0; i < expected.size(); ++i) {
            String expectedPathInfo = expected.get(i);
            String actualPathInfo = pathInfo.get(i);
            if (expectedPathInfo.startsWith("*") || expectedPathInfo.startsWith(":") || expectedPathInfo.equals(actualPathInfo)) continue;
            violationIndex = i;
        }
        return violationIndex;
    }

    ParsedJobUrl parseBlueOceanRestPipelineUrl(List<String> pathInfo) {
        ArrayList<String> jobUrlPattern;
        Integer stepId;
        String nodeId;
        Long runNumber;
        List<Object> job;
        if (pathInfo.size() > 14 && this.isUrlPathInfoMatch(pathInfo, "blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber", "nodes", ":node", "steps", ":step", "*")) {
            job = Arrays.asList(pathInfo.get(5), pathInfo.get(7));
            runNumber = Long.parseLong(pathInfo.get(9));
            nodeId = pathInfo.get(11);
            stepId = Integer.parseInt(pathInfo.get(13));
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber", "nodes", ":node", "steps", ":step"));
            if (pathInfo.size() > jobUrlPattern.size() + 1) {
                jobUrlPattern.add("*");
            } else {
                jobUrlPattern.add(pathInfo.get(jobUrlPattern.size()));
            }
        } else if (pathInfo.size() > 10 && this.isUrlPathInfoMatch(pathInfo, "blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "runs", ":runNumber", "steps", ":step", "*")) {
            job = Collections.singletonList(pathInfo.get(5));
            runNumber = Long.parseLong(pathInfo.get(7));
            nodeId = null;
            stepId = Integer.parseInt(pathInfo.get(9));
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "runs", ":runNumber", "steps", ":step"));
            if (pathInfo.size() > jobUrlPattern.size() + 1) {
                jobUrlPattern.add("*");
            } else {
                jobUrlPattern.add(pathInfo.get(jobUrlPattern.size()));
            }
        } else if (pathInfo.size() > 13 && this.isUrlPathInfoMatch(pathInfo, "blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber", "nodes", ":node", "steps", "*")) {
            job = Arrays.asList(pathInfo.get(5), pathInfo.get(7));
            runNumber = Long.parseLong(pathInfo.get(9));
            nodeId = pathInfo.get(11);
            stepId = Integer.parseInt(pathInfo.get(13));
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber", "nodes", ":node", "steps"));
            if (pathInfo.size() > jobUrlPattern.size() + 1) {
                jobUrlPattern.add("*");
            } else {
                jobUrlPattern.add(pathInfo.get(jobUrlPattern.size()));
            }
        } else if (pathInfo.size() > 12 && this.isUrlPathInfoMatch(pathInfo, "blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber", "nodes", ":node", "*")) {
            job = Arrays.asList(pathInfo.get(5), pathInfo.get(7));
            runNumber = Long.parseLong(pathInfo.get(9));
            nodeId = pathInfo.get(11);
            stepId = null;
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber", "nodes", ":node"));
            if (pathInfo.size() > jobUrlPattern.size() + 1) {
                jobUrlPattern.add("*");
            } else {
                jobUrlPattern.add(pathInfo.get(jobUrlPattern.size()));
            }
        } else if (pathInfo.size() > 8 && this.isUrlPathInfoMatch(pathInfo, "blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "runs", ":runNumber")) {
            job = Collections.singletonList(pathInfo.get(5));
            runNumber = Long.parseLong(pathInfo.get(7));
            nodeId = null;
            stepId = null;
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "runs", ":runNumber"));
            if (pathInfo.size() > jobUrlPattern.size() + 1) {
                jobUrlPattern.add("*");
            } else {
                jobUrlPattern.add(pathInfo.get(jobUrlPattern.size()));
            }
        } else if (pathInfo.size() > 10 && this.isUrlPathInfoMatch(pathInfo, "blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber")) {
            job = Arrays.asList(pathInfo.get(5), pathInfo.get(7));
            runNumber = Long.parseLong(pathInfo.get(9));
            nodeId = null;
            stepId = null;
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber"));
            if (pathInfo.size() > jobUrlPattern.size() + 1) {
                jobUrlPattern.add("*");
            } else {
                jobUrlPattern.add(pathInfo.get(jobUrlPattern.size()));
            }
        } else if (pathInfo.size() > 9 && this.isUrlPathInfoMatch(pathInfo, "blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber")) {
            job = Arrays.asList(pathInfo.get(5), pathInfo.get(7));
            runNumber = Long.parseLong(pathInfo.get(9));
            nodeId = null;
            stepId = null;
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber"));
        } else if (pathInfo.size() > 7 && this.isUrlPathInfoMatch(pathInfo, "blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "runs", ":runNumber")) {
            job = Collections.singletonList(pathInfo.get(5));
            runNumber = Long.parseLong(pathInfo.get(7));
            nodeId = null;
            stepId = null;
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "runs", ":runNumber"));
        } else if (pathInfo.size() > 6 && this.isUrlPathInfoMatch(pathInfo, "blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "*")) {
            job = Collections.singletonList(pathInfo.get(5));
            runNumber = null;
            nodeId = null;
            stepId = null;
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "*"));
        } else if (pathInfo.size() > 4 && this.isUrlPathInfoMatch(pathInfo, "blue", "organizations", ":organization", ":pipelineName", "activity")) {
            job = Collections.singletonList(pathInfo.get(3));
            runNumber = null;
            nodeId = null;
            stepId = null;
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "organizations", ":organization", ":pipelineName", "activity"));
        } else if (pathInfo.size() > 1 && this.isUrlPathInfoMatch(Arrays.asList("blue", "rest", "*"), new String[0])) {
            job = Collections.emptyList();
            runNumber = null;
            nodeId = null;
            stepId = null;
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "*"));
        } else {
            job = Collections.emptyList();
            runNumber = null;
            nodeId = null;
            stepId = null;
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "*"));
        }
        return new ParsedBlueOceanPipelineJobUrl(job, runNumber, jobUrlPattern, nodeId, stepId);
    }

    ParsedJobUrl parseJobUrl(List<String> pathInfo) {
        String runSegment;
        if (pathInfo.isEmpty()) {
            throw new IllegalArgumentException("Job URL cannot be empty");
        }
        ListIterator<String> pathInfoTokensIt = pathInfo.listIterator();
        String firstToken = pathInfo.get(0);
        if (!"job".equals(firstToken)) {
            throw new IllegalArgumentException("Job URL.pathInfo doesn't start with '/job': " + pathInfo.stream().collect(Collectors.joining("/")));
        }
        ArrayList<String> jobName = new ArrayList<String>(5);
        ArrayList<String> jobUrlPattern = new ArrayList<String>(Arrays.asList("job", ":jobFullName"));
        int idx = 0;
        while (pathInfoTokensIt.hasNext()) {
            String nextToken;
            String token = (String)pathInfoTokensIt.next();
            String previousToken = idx == 0 ? null : pathInfo.get(idx - 1);
            String string = nextToken = pathInfoTokensIt.hasNext() ? pathInfo.get(idx + 1) : null;
            if ("job".equals(previousToken)) {
                jobName.add(token);
                if (!"job".equals(nextToken)) break;
            } else if (!"job".equals(token)) {
                throw new IllegalStateException("Unexpected token '" + token + "' with previousToken '" + previousToken + "' and nextToken '" + nextToken + "' in " + pathInfo.stream().collect(Collectors.joining("/")));
            }
            ++idx;
        }
        if (!pathInfoTokensIt.hasNext()) {
            return new ParsedJobUrl(jobName, null, jobUrlPattern);
        }
        String token = (String)pathInfoTokensIt.next();
        if ("lastBuild".equals(token)) {
            jobUrlPattern.add("lastBuild");
            if (pathInfoTokensIt.hasNext()) {
                runSegment = (String)pathInfoTokensIt.next();
                jobUrlPattern.add(runSegment);
                if ("artifact".equals(runSegment)) {
                    jobUrlPattern.add(":artifact");
                } else if ("descriptorByName".equals(runSegment)) {
                    jobUrlPattern.add(":descriptor");
                    if (pathInfoTokensIt.hasNext()) {
                        jobUrlPattern.add(":method");
                    }
                } else {
                    pathInfoTokensIt.forEachRemaining(jobUrlPattern::add);
                }
            }
            return new ParsedJobUrl(jobName, null, jobUrlPattern);
        }
        if (StringUtils.isNumeric((String)token)) {
            Long runNumber = Long.parseLong(token);
            jobUrlPattern.add(":runNumber");
            if (pathInfoTokensIt.hasNext()) {
                runSegment = (String)pathInfoTokensIt.next();
                jobUrlPattern.add(runSegment);
                if ("artifact".equals(runSegment)) {
                    jobUrlPattern.add(":artifact");
                } else if ("descriptorByName".equals(runSegment)) {
                    jobUrlPattern.add(":descriptor");
                    if (pathInfoTokensIt.hasNext()) {
                        jobUrlPattern.add(":method");
                    }
                } else if ("execution".equals(runSegment)) {
                    jobUrlPattern.add(":execution");
                    jobUrlPattern.add("*");
                } else {
                    pathInfoTokensIt.forEachRemaining(jobUrlPattern::add);
                }
            }
            return new ParsedJobUrl(jobName, runNumber, jobUrlPattern);
        }
        if ("descriptorByName".equals(token)) {
            jobUrlPattern.add("descriptorByName");
            jobUrlPattern.add(":descriptor");
            jobUrlPattern.add("*");
            return new ParsedJobUrl(jobName, null, jobUrlPattern);
        }
        jobUrlPattern.add(token);
        pathInfoTokensIt.forEachRemaining(jobUrlPattern::add);
        return new ParsedJobUrl(jobName, null, jobUrlPattern);
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return OpenTelemetryServletFilter.class.hashCode();
    }

    public static class ParsedJobUrl {
        @Nullable
        final String jobName;
        @Nullable
        final Long runNumber;
        final String urlPattern;

        public ParsedJobUrl(List<String> jobName, @Nullable Long runNumber, List<String> urlPattern) {
            this(jobName.stream().collect(Collectors.joining("/")), runNumber, "/" + urlPattern.stream().collect(Collectors.joining("/")));
        }

        public ParsedJobUrl(@Nullable String jobName, @Nullable Long runNumber, String urlPattern) {
            this.jobName = jobName;
            this.urlPattern = urlPattern;
            this.runNumber = runNumber;
        }

        public String toString() {
            return "ParsedJobUrl{jobName='" + this.jobName + "'runNumber='" + this.runNumber + "', uri='" + this.urlPattern + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParsedJobUrl that = (ParsedJobUrl)o;
            return Objects.equals(this.jobName, that.jobName) && Objects.equals(this.runNumber, that.runNumber) && Objects.equals(this.urlPattern, that.urlPattern);
        }

        public int hashCode() {
            return Objects.hash(this.jobName, this.runNumber, this.urlPattern);
        }
    }

    public static class ParsedBlueOceanPipelineJobUrl
    extends ParsedJobUrl {
        final String flowNodeId;
        final Integer stepId;

        public ParsedBlueOceanPipelineJobUrl(List<String> jobName, @Nullable Long runNumber, List<String> urlPattern, @Nullable String flowNodeId, @Nullable Integer stepId) {
            super(jobName, runNumber, urlPattern);
            this.flowNodeId = flowNodeId;
            this.stepId = stepId;
        }

        public ParsedBlueOceanPipelineJobUrl(@Nullable String jobName, @Nullable Long runNumber, @Nullable String flowNodeId, @Nullable Integer stepId, @Nullable String urlPattern) {
            super(jobName, runNumber, urlPattern);
            this.flowNodeId = flowNodeId;
            this.stepId = stepId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ParsedBlueOceanPipelineJobUrl that = (ParsedBlueOceanPipelineJobUrl)o;
            return Objects.equals(this.flowNodeId, that.flowNodeId) && Objects.equals(this.stepId, that.stepId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.flowNodeId, this.stepId);
        }

        @Override
        public String toString() {
            return "ParsedBlueOceanPipelineJobUrl{jobName='" + this.jobName + "', runNumber=" + this.runNumber + ", flowNodeId='" + this.flowNodeId + "', stepId=" + this.stepId + ", urlPattern='" + this.urlPattern + "'}";
        }
    }
}

